/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.AnimationHelper;
import com.denizenscript.denizen.nms.interfaces.EntityAnimation;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Player;

public class AnimateCommand
extends AbstractCommand {
    public AnimateCommand() {
        this.setName("animate");
        this.setSyntax("animate [<entity>|...] [animation:<name>] (for:<player>|...)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        if (arg.startsWith("animation:")) {
            for (EntityEffect entityEffect : EntityEffect.values()) {
                addOne.accept("animation:" + entityEffect.name());
            }
            for (EntityEffect entityEffect : PlayerAnimation.values()) {
                addOne.accept("animation:" + entityEffect.name());
            }
            for (String nmsAnim : AnimationHelper.entityAnimations.keySet()) {
                addOne.accept("animation:" + nmsAnim);
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        AnimationHelper animationHelper = NMSHandler.getAnimationHelper();
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("for") && arg.matchesPrefix("for") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("for", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
            }
            if (scriptEntry.hasObject("animation") || scriptEntry.hasObject("effect") || scriptEntry.hasObject("nms_animation")) continue;
            if (arg.matchesEnum((Enum<?>[])PlayerAnimation.values())) {
                scriptEntry.addObject("animation", PlayerAnimation.valueOf((String)arg.getValue().toUpperCase()));
            }
            if (arg.matchesEnum((Enum<?>[])EntityEffect.values())) {
                scriptEntry.addObject("effect", EntityEffect.valueOf((String)arg.getValue().toUpperCase()));
            }
            if (!animationHelper.hasEntityAnimation(arg.getValue())) continue;
            scriptEntry.addObject("nms_animation", arg.getValue());
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!(scriptEntry.hasObject("effect") || scriptEntry.hasObject("animation") || scriptEntry.hasObject("nms_animation"))) {
            throw new InvalidArgumentsException("Must specify a valid animation!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String nmsAnimation;
        List entities = (List)scriptEntry.getObject("entities");
        List forPlayers = (List)scriptEntry.getObject("for");
        PlayerAnimation animation = scriptEntry.hasObject("animation") ? (PlayerAnimation)scriptEntry.getObject("animation") : null;
        EntityEffect effect = scriptEntry.hasObject("effect") ? (EntityEffect)scriptEntry.getObject("effect") : null;
        String string = nmsAnimation = scriptEntry.hasObject("nms_animation") ? (String)scriptEntry.getObject("nms_animation") : null;
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), (animation != null ? AnimateCommand.db("animation", animation.name()) : (effect != null ? AnimateCommand.db("effect", effect.name()) : AnimateCommand.db("animation", nmsAnimation))) + AnimateCommand.db("entities", entities) + (forPlayers != null ? AnimateCommand.db("for", forPlayers) : ""));
        }
        for (EntityTag entity : entities) {
            if (!entity.isSpawned()) continue;
            try {
                if (animation != null && entity.getBukkitEntity() instanceof Player) {
                    Player player = (Player)entity.getBukkitEntity();
                    animation.play(player);
                    continue;
                }
                if (effect != null) {
                    if (forPlayers != null) {
                        for (PlayerTag player : forPlayers) {
                            NMSHandler.getPacketHelper().sendEntityEffect(player.getPlayerEntity(), entity.getBukkitEntity(), effect.getData());
                        }
                        continue;
                    }
                    entity.getBukkitEntity().playEffect(effect);
                    continue;
                }
                if (nmsAnimation != null) {
                    EntityAnimation entityAnimation = NMSHandler.getAnimationHelper().getEntityAnimation(nmsAnimation);
                    entityAnimation.play(entity.getBukkitEntity());
                    continue;
                }
                Debug.echoError("No way to play the given animation on entity '" + entity + "'");
            }
            catch (Exception e) {
                Debug.echoError(scriptEntry.getResidingQueue(), "Error playing that animation!");
                Debug.echoError(e);
            }
        }
    }
}

