/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.core.CustomScriptContainer;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Map;

public class CustomObjectTag
implements ObjectTag,
Adjustable {
    public CustomScriptContainer container;
    public Map<String, ObjectTag> vars;
    private String prefix = "Custom";
    public static ObjectTagProcessor<CustomObjectTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="custom")
    public static CustomObjectTag valueOf(String string, TagContext context) {
        String typeData;
        Object sc;
        if (ObjectFetcher.isObjectWithProperties(string)) {
            return ObjectFetcher.getObjectFromWithProperties(CustomObjectTag.class, string, context);
        }
        if (string.startsWith("custom@")) {
            string = string.substring("custom@".length());
        }
        if ((sc = ScriptRegistry.getScriptContainer(typeData = string)) == null) {
            if (context == null || context.showErrors()) {
                Debug.echoError("Null script container for " + typeData);
            }
            return null;
        }
        if (!(sc instanceof CustomScriptContainer)) {
            if (context == null || context.showErrors()) {
                Debug.echoError("Wrong-typed script container for " + typeData);
            }
            return null;
        }
        return new CustomObjectTag((CustomScriptContainer)sc, ((CustomScriptContainer)sc).getVars());
    }

    public static CustomObjectTag getFor(ObjectTag obj, TagContext context) {
        return obj instanceof CustomObjectTag ? (CustomObjectTag)obj : CustomObjectTag.valueOf(obj.toString(), context);
    }

    public static boolean matches(String string) {
        return string.startsWith("custom@");
    }

    public CustomObjectTag(CustomScriptContainer type, Map<String, ObjectTag> values) {
        this.container = type;
        this.vars = values;
    }

    @Override
    public String getObjectType() {
        return "Custom";
    }

    @Override
    public String identify() {
        StringBuilder outp = new StringBuilder();
        for (Map.Entry<String, ObjectTag> var : this.vars.entrySet()) {
            outp.append(var.getKey()).append("=").append(PropertyParser.escapePropertyValue(var.getValue().toString())).append(";");
        }
        return "custom@" + this.container.getName() + "[" + (outp.length() > 0 ? outp.substring(0, outp.length() - 1) : "") + "]";
    }

    @Override
    public String identifySimple() {
        return "custom@" + this.container.getName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag specialTagProcessing(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.isComplete()) {
            return this;
        }
        ObjectTag res = this.vars.get(attribute.getAttribute(1));
        if (res != null) {
            return CoreUtilities.autoAttribTyped(res, attribute.fulfill(1));
        }
        String taggo = attribute.getAttributeWithoutParam(1);
        if (this.container.hasPath("tags." + taggo)) {
            ListTag outcomes = this.container.runTagScript(taggo, attribute.getParamObject(), this, attribute.getScriptEntry() != null ? attribute.getScriptEntry().entryData : DenizenCore.getImplementation().getEmptyScriptEntryData());
            if (outcomes == null) {
                return null;
            }
            return CoreUtilities.autoAttribTyped(outcomes.getObject(0), attribute.fulfill(1));
        }
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String name = CoreUtilities.toLowerCase(mechanism.getName());
        if (!mechanism.hasValue()) {
            this.vars.remove(name);
            return;
        }
        ElementTag value = mechanism.getValue();
        if (this.container.hasPath("mechanisms." + name)) {
            ListTag outcomes = this.container.runMechScript(name, this, value);
            if (outcomes == null) {
                return;
            }
            CustomObjectTag co = CustomObjectTag.getFor(outcomes.getObject(0), null);
            this.container = co.container;
            this.vars = co.vars;
        } else {
            this.vars.put(name, value);
        }
        mechanism.fulfill();
    }
}

