/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.entity.Player;

public class ExperienceCommand
extends AbstractCommand {
    public ExperienceCommand() {
        this.setName("experience");
        this.setSyntax("experience [{set}/give/take] (level) [<#>]");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    public static void setTotalExperience(Player player, int exp) {
        player.setTotalExperience(0);
        player.setLevel(0);
        player.setExp(0.0f);
        player.giveExp(exp);
    }

    public static void takeExperience(Player player, int toTake) {
        int pastLevelStart = (int)(player.getExp() * (float)player.getExpToLevel());
        while (toTake >= pastLevelStart) {
            toTake -= pastLevelStart;
            player.setExp(0.0f);
            if (player.getLevel() == 0) {
                return;
            }
            player.setLevel(player.getLevel() - 1);
            pastLevelStart = player.getExpToLevel();
        }
        int newAmount = pastLevelStart - toTake;
        player.setExp((float)newAmount / (float)player.getExpToLevel());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        int amount = 0;
        Type type = Type.SET;
        boolean level = false;
        boolean silent = false;
        for (Argument arg : scriptEntry) {
            if (arg.matchesInteger()) {
                amount = arg.asElement().asInt();
                continue;
            }
            if (arg.matches("set", "give", "take")) {
                type = Type.valueOf(arg.asElement().asString().toUpperCase());
                continue;
            }
            if (arg.matches("level")) {
                level = true;
                continue;
            }
            if (arg.matches("silent")) {
                silent = true;
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.addObject("quantity", amount).addObject("type", (Object)type).addObject("level", level).addObject("silent", silent);
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        int quantity = (Integer)scriptEntry.getObject("quantity");
        Boolean level = (Boolean)scriptEntry.getObject("level");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.name, ExperienceCommand.db("Type", type.toString()) + ExperienceCommand.db("Quantity", level != false ? quantity + " levels" : Integer.valueOf(quantity)) + ExperienceCommand.db("Player", Utilities.getEntryPlayer(scriptEntry).getName()));
        }
        Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
        switch (type) {
            case SET: {
                if (level.booleanValue()) {
                    Utilities.getEntryPlayer(scriptEntry).setLevel(quantity);
                    break;
                }
                ExperienceCommand.setTotalExperience(player, quantity);
                break;
            }
            case GIVE: {
                if (level.booleanValue()) {
                    player.setLevel(player.getLevel() + quantity);
                    break;
                }
                player.giveExp(quantity);
                break;
            }
            case TAKE: {
                if (level.booleanValue()) {
                    int value = player.getLevel() - quantity;
                    player.setLevel(value <= 0 ? 0 : value);
                    break;
                }
                ExperienceCommand.takeExperience(player, quantity);
            }
        }
    }

    private static enum Type {
        SET,
        GIVE,
        TAKE;

    }
}

