/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.util.Advancement;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AdvancementCommand
extends AbstractCommand {
    public static final Map<NamespacedKey, Advancement> customRegistered = new HashMap<NamespacedKey, Advancement>();

    public AdvancementCommand() {
        this.setName("advancement");
        this.setSyntax("advancement [id:<name>] (delete/grant:<players>/revoke:<players>/{create}) (parent:<name>) (icon:<item>) (title:<text>) (description:<text>) (background:<key>) (frame:<type>) (toast:<boolean>) (announce:<boolean>) (hidden:<boolean>) (x:<offset>) (y:<offset>) (progress_length:<#>)");
        this.setRequiredArguments(1, 14);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("parent") && arg.matchesPrefix("parent")) {
                scriptEntry.addObject("parent", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("create") && arg.matches("create")) {
                scriptEntry.addObject("create", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("delete") && arg.matches("delete", "remove")) {
                scriptEntry.addObject("delete", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("grant") && arg.matchesPrefix("grant", "give", "g") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("grant", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("revoke") && arg.matchesPrefix("revoke", "take", "r") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("revoke", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("icon") && arg.matchesPrefix("icon", "i") && arg.matchesArgumentType(ItemTag.class)) {
                scriptEntry.addObject("icon", arg.asType(ItemTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("title") && arg.matchesPrefix("title", "text", "t")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("description") && arg.matchesPrefix("description", "desc", "d")) {
                scriptEntry.addObject("description", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("background") && arg.matchesPrefix("background", "bg")) {
                scriptEntry.addObject("background", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("frame") && arg.matchesPrefix("frame", "f") && arg.matchesEnum(Advancement.Frame.values())) {
                scriptEntry.addObject("frame", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("toast") && arg.matchesPrefix("toast", "show") && arg.matchesBoolean()) {
                scriptEntry.addObject("toast", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("announce") && arg.matchesPrefix("announce", "chat") && arg.matchesBoolean()) {
                scriptEntry.addObject("announce", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("hidden") && arg.matchesPrefix("hidden", "hide", "h") && arg.matchesBoolean()) {
                scriptEntry.addObject("hidden", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("x") && arg.matchesPrefix("x") && arg.matchesFloat()) {
                scriptEntry.addObject("x", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("y") && arg.matchesPrefix("y") && arg.matchesFloat()) {
                scriptEntry.addObject("y", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("progress_length") && arg.matchesPrefix("progress_length") && arg.matchesInteger()) {
                scriptEntry.addObject("progress_length", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an ID!");
        }
        scriptEntry.defaultObject("icon", new ItemTag(Material.AIR));
        scriptEntry.defaultObject("title", new ElementTag(""));
        scriptEntry.defaultObject("description", new ElementTag(""));
        scriptEntry.defaultObject("background", new ElementTag("minecraft:textures/gui/advancements/backgrounds/stone.png"));
        scriptEntry.defaultObject("frame", new ElementTag("TASK"));
        scriptEntry.defaultObject("toast", new ElementTag(true));
        scriptEntry.defaultObject("announce", new ElementTag(true));
        scriptEntry.defaultObject("hidden", new ElementTag(false));
        scriptEntry.defaultObject("x", new ElementTag(0.0f));
        scriptEntry.defaultObject("y", new ElementTag(0.0f));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag id = scriptEntry.getElement("id");
        ElementTag parent = scriptEntry.getElement("parent");
        ElementTag delete = scriptEntry.getElement("delete");
        ListTag grant = (ListTag)scriptEntry.getObjectTag("grant");
        ListTag revoke = (ListTag)scriptEntry.getObjectTag("revoke");
        ItemTag icon = (ItemTag)scriptEntry.getObjectTag("icon");
        ElementTag title = scriptEntry.getElement("title");
        ElementTag description = scriptEntry.getElement("description");
        ElementTag background = scriptEntry.getElement("background");
        ElementTag frame = scriptEntry.getElement("frame");
        ElementTag toast = scriptEntry.getElement("toast");
        ElementTag announce = scriptEntry.getElement("announce");
        ElementTag hidden = scriptEntry.getElement("hidden");
        ElementTag x = scriptEntry.getElement("x");
        ElementTag y = scriptEntry.getElement("y");
        ElementTag progressLength = scriptEntry.getElement("progress_length");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.name, id.debug() + (parent != null ? parent.debug() : "") + (delete != null ? delete.debug() : "") + (grant != null ? grant.debug() : "") + (revoke != null ? revoke.debug() : "") + icon.debug() + title.debug() + description.debug() + (background != null ? background.debug() : "") + (progressLength != null ? progressLength.debug() : "") + frame.debug() + toast.debug() + announce.debug() + hidden.debug() + x.debug() + y.debug());
        }
        AdvancementHelper advancementHelper = NMSHandler.getAdvancementHelper();
        NamespacedKey key = new NamespacedKey((Plugin)Denizen.getInstance(), id.asString());
        if (delete == null && grant == null && revoke == null) {
            NamespacedKey parentKey = null;
            NamespacedKey backgroundKey = null;
            if (parent != null) {
                List<String> split = CoreUtilities.split(parent.asString(), ':', 2);
                parentKey = split.size() == 1 ? new NamespacedKey((Plugin)Denizen.getInstance(), split.get(0)) : new NamespacedKey(CoreUtilities.toLowerCase(split.get(0)), CoreUtilities.toLowerCase(split.get(1)));
            } else if (background != null) {
                List<String> backgroundSplit = CoreUtilities.split(background.asString(), ':', 2);
                backgroundKey = backgroundSplit.size() == 1 ? NamespacedKey.minecraft((String)backgroundSplit.get(0)) : new NamespacedKey(CoreUtilities.toLowerCase(backgroundSplit.get(0)), CoreUtilities.toLowerCase(backgroundSplit.get(1)));
            }
            Advancement advancement = new Advancement(false, key, parentKey, icon.getItemStack(), title.asString(), description.asString(), backgroundKey, Advancement.Frame.valueOf(frame.asString().toUpperCase()), toast.asBoolean(), announce.asBoolean(), hidden.asBoolean(), x.asFloat(), y.asFloat(), progressLength == null ? 1 : progressLength.asInt());
            advancementHelper.register(advancement);
            customRegistered.put(key, advancement);
        } else if (delete != null) {
            advancementHelper.unregister(customRegistered.get(key));
            customRegistered.remove(key);
        } else if (grant != null) {
            Advancement advancement = customRegistered.get(key);
            for (PlayerTag target : grant.filter(PlayerTag.class, scriptEntry)) {
                Player player = target.getPlayerEntity();
                if (player == null) continue;
                if (progressLength == null) {
                    advancementHelper.grant(advancement, player);
                    continue;
                }
                advancementHelper.grantPartial(advancement, player, progressLength.asInt());
            }
        } else {
            Advancement advancement = customRegistered.get(key);
            for (PlayerTag target : revoke.filter(PlayerTag.class, scriptEntry)) {
                Player player = target.getPlayerEntity();
                if (player == null) continue;
                advancementHelper.revoke(advancement, player);
            }
        }
    }
}

