/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.SittingTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sittable;

public class SitCommand
extends AbstractCommand {
    public SitCommand() {
        this.setName("sit");
        this.setSyntax("sit (<location>)");
        this.setRequiredArguments(0, 1);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matchesArgumentType(LocationTag.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Entity entity;
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (!(npc.getEntity() instanceof Player) && !(npc.getEntity() instanceof Sittable)) {
            Debug.echoError("Entities of type " + npc.getEntityType().getName() + " cannot sit.");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), SitCommand.db("npc", npc) + (location != null ? location.debug() : ""));
        }
        if ((entity = npc.getEntity()) instanceof Sittable) {
            ((Sittable)entity).setSitting(true);
        } else {
            SittingTrait trait = (SittingTrait)npc.getCitizen().getOrAddTrait(SittingTrait.class);
            if (location != null) {
                trait.sit(location);
            } else {
                trait.sit();
            }
        }
    }
}

