/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import net.milkbowl.vault.economy.Economy;

public class MoneyCommand
extends AbstractCommand {
    public MoneyCommand() {
        this.setName("money");
        this.setSyntax("money [give/take/set] (quantity:<#.#>) (players:<player>|...)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (Depends.economy == null) {
            Debug.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            return;
        }
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesPrefix("quantity", "qty", "q") && arg.matchesFloat()) {
                if (arg.matchesPrefix("q", "qty")) {
                    Deprecations.qtyTags.warn(scriptEntry);
                }
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("to", "from", "players", "player") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("quantity", new ElementTag(1));
        if (!scriptEntry.hasObject("players")) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsException("This command must have a player attached!");
            }
            scriptEntry.addObject("players", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry)));
        } else if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid action!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag action = scriptEntry.getElement("action");
        ElementTag quantity = scriptEntry.getElement("quantity");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), MoneyCommand.db("Player(s)", players) + action.debug() + quantity.debug());
        }
        Economy eco = Depends.economy;
        double amt = quantity.asDouble();
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case GIVE: {
                for (PlayerTag player : players) {
                    eco.depositPlayer(player.getOfflinePlayer(), amt);
                }
                break;
            }
            case TAKE: {
                for (PlayerTag player : players) {
                    eco.withdrawPlayer(player.getOfflinePlayer(), amt);
                }
                break;
            }
            case SET: {
                for (PlayerTag player : players) {
                    double balance = eco.getBalance(player.getOfflinePlayer());
                    if (amt > balance) {
                        eco.depositPlayer(player.getOfflinePlayer(), amt - balance);
                        continue;
                    }
                    eco.withdrawPlayer(player.getOfflinePlayer(), balance - amt);
                }
                break;
            }
        }
    }

    static enum Action {
        GIVE,
        TAKE,
        SET;

    }
}

