/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import java.util.List;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;

public class RandomCommand
extends BracedCommand {
    private int previous = 0;
    private int previous2 = 0;
    private int previous3 = 0;

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        List<BracedCommand.BracedData> bdat = RandomCommand.getBracedCommands(scriptEntry);
        if (bdat != null && bdat.size() > 0) {
            scriptEntry.addObject("braces", bdat);
        }
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("{")) break;
            if (!scriptEntry.hasObject("possibilities") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("possibilities", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("braces")) {
            if (!scriptEntry.hasObject("possibilities")) {
                throw new InvalidArgumentsException("Missing possibilities!");
            }
            if (scriptEntry.getElement("possibilities").asInt() <= 1) {
                throw new InvalidArgumentsException("Must randomly select more than one item.");
            }
            if (scriptEntry.getResidingQueue().getQueueSize() < scriptEntry.getElement("possibilities").asInt()) {
                throw new InvalidArgumentsException("Invalid Size! Random # must not be larger than the script!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        int possibilities = 0;
        ScriptQueue queue = scriptEntry.getResidingQueue();
        List<ScriptEntry> bracedCommands = null;
        if (!scriptEntry.hasObject("braces")) {
            possibilities = scriptEntry.getElement("possibilities").asInt();
        } else {
            bracedCommands = ((BracedCommand.BracedData)((List)scriptEntry.getObject((String)"braces")).get((int)0)).value;
            possibilities = bracedCommands.size();
        }
        int selected = CoreUtilities.getRandom().nextInt(possibilities);
        if (selected == this.previous || selected == this.previous2 || selected == this.previous3) {
            selected = CoreUtilities.getRandom().nextInt(possibilities);
        }
        if (selected == this.previous || selected == this.previous2 || selected == this.previous3) {
            selected = CoreUtilities.getRandom().nextInt(possibilities);
        }
        this.previous3 = this.previous2;
        this.previous2 = this.previous;
        this.previous = selected;
        scriptEntry.addObject("possibilities", new Element(possibilities));
        scriptEntry.addObject("selected", new Element(selected));
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("possibilities", possibilities) + aH.debugObj("choice", selected + 1));
        }
        scriptEntry.setInstant(true);
        if (bracedCommands == null) {
            ScriptEntry keeping = null;
            for (int x = 0; x < possibilities; ++x) {
                if (x != selected) {
                    queue.removeEntry(0);
                    continue;
                }
                dB.echoDebug((Debuggable)scriptEntry, "...selected '" + queue.getEntry(0).getCommandName() + ": " + queue.getEntry(0).getArguments() + "'.");
                keeping = queue.getEntry(0);
                queue.removeEntry(0);
            }
            queue.injectEntry(keeping, 0);
        } else {
            queue.injectEntry(bracedCommands.get(selected).addObject("reqid", scriptEntry.getObject("reqid")), 0);
        }
    }
}

