/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LeashHitch;

public class LeashCommand
extends AbstractCommand {
    public LeashCommand() {
        this.setName("leash");
        this.setSyntax("leash (cancel) [<entity>|...] (holder:<entity>/<location>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel", "stop")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("holder") && arg.matchesPrefix("holder", "h")) {
                if (arg.matchesArgumentType(EntityTag.class)) {
                    scriptEntry.addObject("holder", arg.asType(EntityTag.class));
                    continue;
                }
                if (!arg.matchesArgumentType(LocationTag.class)) continue;
                scriptEntry.addObject("holder", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("cancel")) {
            scriptEntry.defaultObject("holder", Utilities.entryDefaultEntity(scriptEntry, false));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        EntityTag holder = null;
        LocationTag holderLoc = null;
        Entity Holder2 = null;
        Object holderObject = scriptEntry.getObject("holder");
        if (holderObject instanceof EntityTag) {
            holder = (EntityTag)scriptEntry.getObjectTag("holder");
            Holder2 = holder.getBukkitEntity();
        } else if (holderObject instanceof LocationTag) {
            holderLoc = (LocationTag)scriptEntry.getObjectTag("holder");
            Material material = holderLoc.getBlock().getType();
            if (material.name().endsWith("_FENCE")) {
                Holder2 = holderLoc.getWorld().spawn((Location)holderLoc, LeashHitch.class);
            } else {
                Debug.echoError(scriptEntry.getResidingQueue(), "Bad holder location specified - only fences are permitted!");
                return;
            }
        }
        boolean cancel = scriptEntry.hasObject("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), cancel ? LeashCommand.db("cancel", "true") : "", LeashCommand.db("entities", entities.toString()), holder != null ? LeashCommand.db("holder", holder) : LeashCommand.db("holder", holderLoc));
        }
        for (EntityTag entity : entities) {
            if (!entity.isSpawned() || !entity.isLivingEntity()) continue;
            if (cancel) {
                entity.getLivingEntity().setLeashHolder(null);
                continue;
            }
            entity.getLivingEntity().setLeashHolder(Holder2);
        }
    }
}

