/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.npc.traits.ConstantsTrait;
import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Paginator;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.projectiles.ProjectileSource;

public class AssignmentTrait
extends Trait {
    @Persist
    private String assignment = "";
    private AssignmentScriptContainer cachedContainer = null;
    private UUID entityId;

    public AssignmentTrait() {
        super("assignment");
    }

    public void load(DataKey key) {
        if (!this.hasAssignment()) {
            Debug.echoError("Missing assignment '" + this.assignment + "' for NPC '" + this.npc.getName() + "'/" + this.npc.getId() + "! Perhaps the script has been removed?");
        }
        ((ConstantsTrait)this.npc.getOrAddTrait(ConstantsTrait.class)).rebuildAssignmentConstants();
    }

    public boolean setAssignment(String assignment, PlayerTag player) {
        this.cachedContainer = null;
        if (ScriptRegistry.containsScript(assignment, AssignmentScriptContainer.class)) {
            this.assignment = assignment.toUpperCase();
            if (!this.npc.hasTrait(ConstantsTrait.class)) {
                this.npc.addTrait(ConstantsTrait.class);
            }
            if (!this.npc.hasTrait(TriggerTrait.class)) {
                this.npc.addTrait(TriggerTrait.class);
            }
            if (Settings.healthTraitEnabledByDefault() && !this.npc.hasTrait(HealthTrait.class)) {
                this.npc.addTrait(HealthTrait.class);
            }
            ((ConstantsTrait)this.npc.getOrAddTrait(ConstantsTrait.class)).rebuildAssignmentConstants();
            new NPCTag(this.npc).action("assignment", player);
            return true;
        }
        return false;
    }

    public AssignmentScriptContainer getAssignment() {
        if (this.cachedContainer != null) {
            return this.cachedContainer;
        }
        if (this.assignment == null || this.assignment.equals("")) {
            return null;
        }
        Object script = ScriptRegistry.getScriptContainer(this.assignment);
        if (script instanceof AssignmentScriptContainer) {
            this.cachedContainer = (AssignmentScriptContainer)script;
        }
        return this.cachedContainer;
    }

    @EventHandler
    public void onReload(ScriptReloadEvent event) {
        this.cachedContainer = null;
    }

    public boolean hasAssignment() {
        if (this.assignment == null || this.assignment.equals("")) {
            return false;
        }
        return ScriptRegistry.containsScript(this.assignment);
    }

    public void removeAssignment(PlayerTag player) {
        new NPCTag(this.npc).action("remove assignment", player);
        this.cachedContainer = null;
        this.assignment = "";
    }

    public void describe(CommandSender sender, int page) throws CommandException {
        AssignmentScriptContainer assignmentScript = (AssignmentScriptContainer)ScriptRegistry.getScriptContainer(this.assignment);
        Paginator paginator = new Paginator().header("Assignment");
        paginator.addLine("<e>Current assignment: " + (this.hasAssignment() ? this.assignment : "None.") + "");
        paginator.addLine("");
        if (!this.hasAssignment()) {
            paginator.sendPage(sender, page);
            return;
        }
        boolean entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Interact Scripts:");
        paginator.addLine("<e>Key: <a>Priority  <b>Name");
        if (assignmentScript.contains("INTERACT SCRIPTS", List.class)) {
            entriesPresent = true;
            for (String scriptEntry : assignmentScript.getStringList("INTERACT SCRIPTS")) {
                paginator.addLine("<b>" + scriptEntry);
            }
        }
        if (!entriesPresent) {
            paginator.addLine("<c>No Interact Scripts assigned.");
        }
        paginator.addLine("");
        if (!entriesPresent) {
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing");
            }
            return;
        }
        entriesPresent = false;
        paginator.addLine(ChatColor.GRAY + "Actions:");
        paginator.addLine("<e>Key: <a>Action name  <b>Script Size");
        if (assignmentScript.contains("ACTIONS", Map.class)) {
            entriesPresent = true;
        }
        if (entriesPresent) {
            for (StringHolder action : assignmentScript.getConfigurationSection("ACTIONS").getKeys(false)) {
                paginator.addLine("<a>" + action.str + " <b>" + assignmentScript.getStringList("ACTIONS." + action.str).size());
            }
        } else {
            paginator.addLine("<c>No actions defined in the assignment.");
        }
        paginator.addLine("");
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing", new Object[]{page});
        }
    }

    public void onSpawn() {
        this.entityId = this.npc.getEntity().getUniqueId();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent deathEvent) {
        if (!deathEvent.getEntity().getUniqueId().equals(this.entityId)) {
            return;
        }
        EntityDamageEvent event = deathEvent.getEntity().getLastDamageCause();
        String deathCause = event == null ? "unknown" : CoreUtilities.toLowerCase(event.getCause().toString()).replace('_', ' ');
        HashMap<String, ObjectTag> context = new HashMap<String, ObjectTag>();
        context.put("damage", new ElementTag(event == null ? 0.0 : event.getDamage()));
        context.put("death_cause", new ElementTag(deathCause));
        PlayerTag player = null;
        if (event instanceof EntityDamageByEntityEvent) {
            ProjectileSource shooter;
            Entity killerEntity = ((EntityDamageByEntityEvent)event).getDamager();
            context.put("killer", new EntityTag(killerEntity).getDenizenObject());
            if (killerEntity instanceof Player) {
                player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)killerEntity));
            } else if (killerEntity instanceof Projectile && (shooter = ((Projectile)killerEntity).getShooter()) instanceof LivingEntity) {
                context.put("shooter", new EntityTag((Entity)((LivingEntity)shooter)).getDenizenObject());
                if (shooter instanceof Player) {
                    player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)shooter));
                }
                new NPCTag(this.npc).action("death by " + ((LivingEntity)shooter).getType().toString(), player, context);
            }
            new NPCTag(this.npc).action("death by entity", player, context);
            new NPCTag(this.npc).action("death by " + killerEntity.getType().toString(), player, context);
        } else if (event instanceof EntityDamageByBlockEvent) {
            new NPCTag(this.npc).action("death by block", null, context);
        }
        new NPCTag(this.npc).action("death", player, context);
        new NPCTag(this.npc).action("death by " + deathCause, player, context);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHit(EntityDamageByEntityEvent event) {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.getDamager() != this.npc.getEntity()) {
            if (event.getDamager() instanceof Projectile) {
                if (((Projectile)event.getDamager()).getShooter() != this.npc.getEntity()) {
                    return;
                }
            } else {
                return;
            }
        }
        PlayerTag player = null;
        if (event.getEntity() instanceof Player) {
            player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)event.getEntity()));
        }
        new NPCTag(this.npc).action("hit", player);
        new NPCTag(this.npc).action("hit on " + event.getEntityType().name(), player);
        if (event.getEntity() instanceof LivingEntity && ((LivingEntity)event.getEntity()).getHealth() - event.getFinalDamage() <= 0.0) {
            new NPCTag(this.npc).action("kill", player);
            new NPCTag(this.npc).action("kill of " + event.getEntityType().name(), player);
        }
    }
}

