/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.trade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dTrade;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.inventory.ItemStack;

public class TradeInputs
implements Property {
    public static final String[] handledTags = new String[]{"inputs"};
    public static final String[] handledMechs = new String[]{"inputs"};
    private dTrade recipe;

    public static boolean describes(dObject recipe) {
        return recipe instanceof dTrade;
    }

    public static TradeInputs getFrom(dObject recipe) {
        if (!TradeInputs.describes(recipe)) {
            return null;
        }
        return new TradeInputs((dTrade)recipe);
    }

    public TradeInputs(dTrade recipe) {
        this.recipe = recipe;
    }

    @Override
    public String getPropertyString() {
        if (this.recipe.getRecipe() == null) {
            return null;
        }
        dList ingredients = new dList();
        for (ItemStack item : this.recipe.getRecipe().getIngredients()) {
            ingredients.addObject(new dItem(item));
        }
        return ingredients.identify();
    }

    @Override
    public String getPropertyId() {
        return "inputs";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("inputs")) {
            ArrayList<dItem> itemList = new ArrayList<dItem>();
            for (ItemStack item : this.recipe.getRecipe().getIngredients()) {
                itemList.add(new dItem(item));
            }
            return new dList((Collection<? extends dObject>)itemList).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("inputs")) {
            List<Object> ingredients = new ArrayList<ItemStack>();
            List<dItem> list = mechanism.getValue().asType(dList.class).filter(dItem.class);
            if (!mechanism.hasValue() || list.isEmpty()) {
                this.recipe.getRecipe().setIngredients(ingredients);
                return;
            }
            for (dItem item : list) {
                ingredients.add(item.getItemStack());
            }
            if (ingredients.size() > 2) {
                dB.echoError("Trade recipe input was given " + list.size() + " items. Only using the first two items!");
                ingredients = ingredients.subList(0, 2);
            }
            this.recipe.getRecipe().setIngredients(ingredients);
        }
    }
}

