/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import net.aufdemrand.denizencore.scripts.ScriptEntry;

public abstract class AbstractCommand
implements RegistrationableInstance {
    private boolean braced = false;
    private boolean preparseArgs = true;
    protected String name;
    public CommandOptions commandOptions;

    public void setBraced() {
        this.braced = true;
    }

    public boolean isBraced() {
        return this.braced;
    }

    public void setParseArgs(boolean parse) {
        this.preparseArgs = parse;
    }

    public boolean shouldPreParse() {
        return this.preparseArgs;
    }

    @Override
    public AbstractCommand activate() {
        return this;
    }

    @Override
    public AbstractCommand as(String commandName) {
        this.name = commandName.toUpperCase();
        DenizenCore.getCommandRegistry().register(this.name, this);
        this.onEnable();
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CommandOptions getOptions() {
        return this.commandOptions;
    }

    public String getUsageHint() {
        return !this.commandOptions.USAGE_HINT.equals("") ? this.commandOptions.USAGE_HINT : "No usage defined! See documentation for more information!";
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void onEnable() {
    }

    public CommandOptions withOptions(String usageHint, int numberOfRequiredArgs) {
        this.commandOptions = new CommandOptions(usageHint, numberOfRequiredArgs);
        return this.commandOptions;
    }

    public abstract void execute(ScriptEntry var1) throws CommandExecutionException;

    public abstract void parseArgs(ScriptEntry var1) throws InvalidArgumentsException;

    public class CommandOptions {
        public String USAGE_HINT;
        public int REQUIRED_ARGS;

        public CommandOptions(String usageHint, int numberOfRequiredArgs) {
            this.USAGE_HINT = usageHint;
            this.REQUIRED_ARGS = numberOfRequiredArgs;
        }
    }
}

