/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.npc;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NPCStuckScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static NPCStuckScriptEvent instance;
    public NavigationStuckEvent event;
    public NPCTag npc;

    public NPCStuckScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("npc stuck");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.npc.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "NPCStuck";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, this.npc);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lowVal = CoreUtilities.toLowerCase(determinationObj.toString());
        if (lowVal.equals("none")) {
            this.event.setAction(null);
            return true;
        }
        if (lowVal.equals("teleport")) {
            this.event.setAction((StuckAction)TeleportStuckAction.INSTANCE);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("action")) {
            return new ElementTag(this.event.getAction() == TeleportStuckAction.INSTANCE ? "teleport" : "none");
        }
        return super.getContext(name);
    }

    @EventHandler
    public void navStuck(NavigationStuckEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.event = event;
        this.fire((Event)event);
    }
}

