/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.CommandScriptHelper;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenCommand;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;

public class CommandScriptContainer
extends ScriptContainer {
    public CommandScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        CommandScriptHelper.registerDenizenCommand(new DenizenCommand(this));
    }

    public String getCommandName() {
        return CoreUtilities.toLowerCase(this.getString("NAME", null));
    }

    public String getDescription() {
        return TagManager.tag(this.getString("DESCRIPTION", "").replace("\n", " \n"), new BukkitTagContext(null, null, false, null, false, new dScript(this)));
    }

    public String getUsage() {
        return TagManager.tag(this.getString("USAGE", ""), new BukkitTagContext(null, null, false, null, false, new dScript(this)));
    }

    public List<String> getAliases() {
        ArrayList aliases = this.getStringList("ALIASES");
        return aliases != null ? aliases : new ArrayList();
    }

    public String getPermission() {
        return this.getString("PERMISSION");
    }

    public String getPermissionMessage() {
        return this.getString("PERMISSION MESSAGE");
    }

    public ScriptQueue runCommandScript(dPlayer player, dNPC npc, Map<String, dObject> context) {
        ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(this.getName())).addEntries(this.getBaseEntries(new BukkitScriptEntryData(player, npc)));
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        return queue;
    }

    public boolean runAllowedHelpProcedure(dPlayer player, dNPC npc, Map<String, dObject> context) {
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "ALLOWED HELP");
        long id = DetermineCommand.getNewId();
        ScriptBuilder.addObjectToEntries(entries, "reqid", id);
        ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(this.getName())).setReqId(id).addEntries(entries);
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        return DetermineCommand.hasOutcome(id) && ((String)DetermineCommand.getOutcome(id).get(0)).equalsIgnoreCase("true");
    }

    public List<String> runTabCompleteProcedure(dPlayer player, dNPC npc, Map<String, dObject> context) {
        List<ScriptEntry> entries = this.getEntries(new BukkitScriptEntryData(player, npc), "TAB COMPLETE");
        long id = DetermineCommand.getNewId();
        ScriptBuilder.addObjectToEntries(entries, "reqid", id);
        ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(this.getName())).setReqId(id).addEntries(entries);
        if (context != null) {
            OldEventManager.OldEventContextSource oecs = new OldEventManager.OldEventContextSource();
            oecs.contexts = context;
            queue.setContextSource(oecs);
        }
        queue.start();
        if (DetermineCommand.hasOutcome(id)) {
            return dList.valueOf((String)DetermineCommand.getOutcome(id).get(0));
        }
        return new ArrayList<String>();
    }

    public boolean hasAllowedHelpProcedure() {
        return this.contains("ALLOWED HELP");
    }

    public boolean hasTabCompleteProcedure() {
        return this.contains("TAB COMPLETE");
    }
}

