/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.nms.interfaces.ChunkHelper;
import com.denizenscript.denizen.utilities.implementation.DenizenCoreImplementation;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.Chunk;
import org.bukkit.craftbukkit.v1_18_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;

public class ChunkHelperImpl
implements ChunkHelper {
    public static final Field chunkProviderServerThreadField = ReflectionHelper.getFields(ChunkProviderServer.class).getFirstOfType(Thread.class);
    public static final MethodHandle chunkProviderServerThreadFieldSetter = ReflectionHelper.getFinalSetterForFirstOfType(ChunkProviderServer.class, Thread.class);
    public static final Field worldThreadField = ReflectionHelper.getFields(World.class).getFirstOfType(Thread.class);
    public static final MethodHandle worldThreadFieldSetter = ReflectionHelper.getFinalSetterForFirstOfType(World.class, Thread.class);
    public Thread resetServerThread;

    @Override
    public void changeChunkServerThread(org.bukkit.World world) {
        if (DenizenCoreImplementation.tagThread == null) {
            return;
        }
        if (this.resetServerThread != null) {
            return;
        }
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ChunkProviderServer provider = nmsWorld.k();
        try {
            this.resetServerThread = (Thread)chunkProviderServerThreadField.get(provider);
            chunkProviderServerThreadFieldSetter.invoke(provider, Thread.currentThread());
            worldThreadFieldSetter.invoke(nmsWorld, Thread.currentThread());
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void restoreServerThread(org.bukkit.World world) {
        if (DenizenCoreImplementation.tagThread == null) {
            return;
        }
        if (this.resetServerThread == null) {
            return;
        }
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ChunkProviderServer provider = nmsWorld.k();
        try {
            chunkProviderServerThreadFieldSetter.invoke(provider, this.resetServerThread);
            worldThreadFieldSetter.invoke(nmsWorld, this.resetServerThread);
            this.resetServerThread = null;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public int[] getHeightMap(Chunk chunk) {
        HeightMap map = (HeightMap)((CraftChunk)chunk).getHandle().g.get(HeightMap.Type.e);
        int[] outputMap = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                outputMap[x * 16 + y] = map.a(x, y);
            }
        }
        return outputMap;
    }
}

