/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen;

import com.denizenscript.denizen.events.ScriptEventRegistry;
import com.denizenscript.denizen.events.bukkit.SavesReloadEvent;
import com.denizenscript.denizen.events.server.ServerPrestartScriptEvent;
import com.denizenscript.denizen.events.server.ServerStartScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.FakeArrow;
import com.denizenscript.denizen.nms.interfaces.FakePlayer;
import com.denizenscript.denizen.nms.interfaces.ItemProjectile;
import com.denizenscript.denizen.npc.DenizenNPCHelper;
import com.denizenscript.denizen.npc.TraitRegistry;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.properties.PropertyRegistry;
import com.denizenscript.denizen.scripts.commands.BukkitCommandRegistry;
import com.denizenscript.denizen.scripts.commands.player.ClickableCommand;
import com.denizenscript.denizen.scripts.containers.ContainerRegistry;
import com.denizenscript.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.scripts.triggers.TriggerRegistry;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizen.tags.core.ServerTagBase;
import com.denizenscript.denizen.utilities.CommonRegistries;
import com.denizenscript.denizen.utilities.LegacySavesUpdater;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.command.CommandEvents;
import com.denizenscript.denizen.utilities.command.DenizenCommandHandler;
import com.denizenscript.denizen.utilities.command.ExCommandHandler;
import com.denizenscript.denizen.utilities.command.ExSustainedCommandHandler;
import com.denizenscript.denizen.utilities.command.NPCCommandHandler;
import com.denizenscript.denizen.utilities.command.manager.CommandManager;
import com.denizenscript.denizen.utilities.command.manager.Injector;
import com.denizenscript.denizen.utilities.command.manager.messaging.Messaging;
import com.denizenscript.denizen.utilities.debugging.BStatsMetricsLite;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.debugging.StatsRecord;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.flags.PlayerFlagHandler;
import com.denizenscript.denizen.utilities.flags.WorldFlagHandler;
import com.denizenscript.denizen.utilities.implementation.DenizenCoreImplementation;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizen.utilities.world.VoidGenerator;
import com.denizenscript.denizen.utilities.world.VoidGenerator1_17;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.core.AdjustCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RunLaterCommand;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.StrongWarning;
import com.denizenscript.denizencore.utilities.text.ConfigUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Denizen
extends JavaPlugin {
    public static Denizen instance;
    public static String versionTag;
    private boolean startedSuccessful = false;
    public static boolean supportsPaper;
    public CommandManager commandManager;
    public TriggerRegistry triggerRegistry;
    public DenizenNPCHelper npcHelper;
    public OldEventManager eventManager;
    public BukkitWorldScriptHelper worldScriptHelper;
    public ItemScriptHelper itemScriptHelper;
    public ExCommandHandler exCommand;
    public DenizenCoreImplementation coreImplementation = new DenizenCoreImplementation();
    public boolean hasDisabled = false;
    private FileConfiguration scoreboardsConfig = null;
    private File scoreboardsConfigFile = null;
    public WorldFlagHandler worldFlags;

    public static Denizen getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        try {
            versionTag = this.getDescription().getVersion();
            CoreUtilities.noDebugContext = new BukkitTagContext(null, null, null, false, null);
            CoreUtilities.basicContext = new BukkitTagContext(null, null, null, true, null);
            CoreUtilities.errorButNoDebugContext = new BukkitTagContext(null, null, null, false, null);
            CoreUtilities.errorButNoDebugContext.showErrors = true;
            DenizenCore.init(this.coreImplementation);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.startedSuccessful = false;
            return;
        }
        PlayerFlagHandler.dataFolder = new File(this.getDataFolder(), "player_flags");
        if (!PlayerFlagHandler.dataFolder.exists()) {
            PlayerFlagHandler.dataFolder.mkdir();
        }
        String javaVersion = System.getProperty("java.version");
        this.getLogger().info("Running on java version: " + javaVersion);
        if (javaVersion.startsWith("8") || javaVersion.startsWith("1.8")) {
            this.getLogger().info("Running on fully supported Java 8. Updating to Java 17+ is recommended.");
        } else if (javaVersion.startsWith("9") || javaVersion.startsWith("1.9") || javaVersion.startsWith("10") || javaVersion.startsWith("1.10") || javaVersion.startsWith("11") || javaVersion.startsWith("12") || javaVersion.startsWith("13") || javaVersion.startsWith("14") || javaVersion.startsWith("15")) {
            this.getLogger().warning("Running unreliable Java version. Old Minecraft is built for Java 8, modern Minecraft is built for Java 17. Other Java versions are not guaranteed to function properly.");
        } else if (javaVersion.startsWith("16")) {
            this.getLogger().info("Running on fully supported Java 16.");
        } else if (javaVersion.startsWith("17")) {
            this.getLogger().info("Running on fully supported Java 17.");
        } else {
            this.getLogger().info("Running on unrecognized (future?) Java version. May or may not work.");
        }
        if (!NMSHandler.initialize(this)) {
            this.getLogger().warning("-------------------------------------");
            this.getLogger().warning("This build of Denizen is not compatible with this Spigot version! Deactivating Denizen!");
            this.getLogger().warning("-------------------------------------");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.startedSuccessful = false;
            return;
        }
        if (!NMSHandler.getInstance().isCorrectMappingsCode()) {
            this.getLogger().warning("-------------------------------------");
            this.getLogger().warning("This build of Denizen was built for a different Spigot revision! This may potentially cause issues. If you are experiencing trouble, update Denizen and Spigot both to latest builds! If this message appears with both Denizen and Spigot fully up-to-date, contact the Denizen team (via GitHub, Spigot, or Discord) to request an update be built.");
            this.getLogger().warning("-------------------------------------");
        }
        BukkitCommandRegistry commandRegistry = new BukkitCommandRegistry();
        this.triggerRegistry = new TriggerRegistry();
        boolean citizensBork = false;
        try {
            Depends.initialize();
            if (Depends.citizens == null) {
                if (Bukkit.getPluginManager().getPlugin("Citizens") != null) {
                    citizensBork = true;
                    this.getLogger().warning("Citizens is present but doesn't seem to be activated! You may have an error earlier in your logs, or you may have a broken plugin load order.");
                } else {
                    this.getLogger().warning("Citizens does not seem to be available! Denizen will have greatly reduced functionality!");
                }
            }
            this.startedSuccessful = true;
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            this.saveDefaultConfig();
            this.reloadConfig();
            Debug.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
            Debug.log(ChatColor.YELLOW + " _/_ _  ._  _ _  ");
            Debug.log(ChatColor.YELLOW + "(/(-/ )/ /_(-/ ) " + ChatColor.GRAY + " scriptable minecraft");
            Debug.log("");
            Debug.log(ChatColor.GRAY + "by: " + ChatColor.WHITE + "The DenizenScript team");
            Debug.log(ChatColor.GRAY + "Chat with us at: " + ChatColor.WHITE + " https://discord.gg/Q6pZGSR");
            Debug.log(ChatColor.GRAY + "Or learn more at: " + ChatColor.WHITE + " https://denizenscript.com");
            Debug.log(ChatColor.GRAY + "version: " + ChatColor.WHITE + versionTag);
            Debug.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            if (Class.forName("com.destroystokyo.paper.PaperConfig") != null) {
                supportsPaper = true;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        try {
            BStatsMetricsLite ex = new BStatsMetricsLite((Plugin)this);
        }
        catch (Throwable e) {
            Debug.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                this.npcHelper = new DenizenNPCHelper();
            }
            this.commandManager = new CommandManager();
            this.commandManager.setInjector(new Injector(new Object[]{this}));
            this.commandManager.register(DenizenCommandHandler.class);
            if (Depends.citizens != null) {
                Depends.citizens.registerCommandClass(NPCCommandHandler.class);
            }
            DenizenEntityType.registerEntityType("ITEM_PROJECTILE", ItemProjectile.class);
            DenizenEntityType.registerEntityType("FAKE_ARROW", FakeArrow.class);
            DenizenEntityType.registerEntityType("FAKE_PLAYER", FakePlayer.class);
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                PlayerTag.notePlayer(player);
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            DenizenCore.commandRegistry = commandRegistry;
            commandRegistry.registerCommands();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            ScriptRegistry._registerCoreTypes();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            ContainerRegistry.registerMainContainers();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            new File(this.getDataFolder() + "/scripts").mkdirs();
            new File(this.getDataFolder() + "/midi").mkdirs();
            new File(this.getDataFolder() + "/schematics").mkdirs();
            if (!new File(this.getDataFolder() + "/midi/Denizen.mid").exists()) {
                String sourceFile = URLDecoder.decode(Denizen.class.getProtectionDomain().getCodeSource().getLocation().getFile());
                Debug.log("Denizen.mid not found, extracting from " + sourceFile);
                Utilities.extractFile(new File(sourceFile), "Denizen.mid", this.getDataFolder() + "/midi/");
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            InputStream properConfig = Denizen.class.getResourceAsStream("/config.yml");
            String properConfigString = ScriptHelper.convertStreamToString(properConfig);
            properConfig.close();
            FileInputStream currentConfig = new FileInputStream(this.getDataFolder() + "/config.yml");
            String currentConfigString = ScriptHelper.convertStreamToString(currentConfig);
            currentConfig.close();
            String updated = ConfigUpdater.updateConfig(currentConfigString, properConfigString);
            if (updated != null) {
                Debug.log("Your config file is outdated. Automatically updating it...");
                FileOutputStream configOutput = new FileOutputStream(this.getDataFolder() + "/config.yml");
                OutputStreamWriter writer = new OutputStreamWriter(configOutput);
                writer.write(updated);
                writer.close();
                configOutput.close();
                this.reloadConfig();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            this.worldScriptHelper = new BukkitWorldScriptHelper();
            this.itemScriptHelper = new ItemScriptHelper();
            new InventoryScriptHelper();
            new EntityScriptHelper();
            new CommandScriptHelper();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                TraitRegistry.registerMainTraits();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                this.triggerRegistry.registerCoreMembers();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            AdjustCommand.specialAdjustables.put("server", ServerTagBase::adjustServer);
            this.eventManager = new OldEventManager();
            ScriptEventRegistry.registerMainEvents();
            ObjectFetcher.registerCoreObjects();
            CommonRegistries.registerMainObjects();
            TagManager.registerCoreTags();
            CommonRegistries.registerMainTagHandlers();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            PropertyRegistry.registerMainProperties();
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            new CommandEvents();
            if (Settings.cache_packetInterceptAutoInit) {
                NetworkInterceptHelper.enable();
            }
        }
        catch (Exception e) {
            Debug.echoError(e);
        }
        try {
            if (supportsPaper) {
                Class<?> clazz = Class.forName("com.denizenscript.denizen.paper.PaperModule");
                clazz.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException ex) {
            supportsPaper = false;
        }
        catch (Throwable ex) {
            supportsPaper = false;
            Debug.echoError(ex);
        }
        Debug.log("Loaded <A>" + commandRegistry.instances.size() + "<W> core commands and <A>" + ObjectFetcher.objectsByPrefix.size() + "<W> core object types.");
        this.exCommand = new ExCommandHandler();
        this.exCommand.enableFor(this.getCommand("ex"));
        ExSustainedCommandHandler exsCommand = new ExSustainedCommandHandler();
        exsCommand.enableFor(this.getCommand("exs"));
        DenizenCore.preloadScripts();
        this.reloadSaves();
        try {
            ServerPrestartScriptEvent.instance.specialHackRunEvent();
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        boolean hadCitizensBork = citizensBork;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            try {
                if (hadCitizensBork) {
                    Depends.setupCitizens();
                    if (Depends.citizens != null) {
                        this.getLogger().warning("Citizens was activated late - this means a plugin load order error occurred. You may have plugins with invalid 'plugin.yml' files (eg that use the 'loadbefore' directive, or that have circular dependencies).");
                        this.npcHelper = new DenizenNPCHelper();
                        Depends.citizens.registerCommandClass(NPCCommandHandler.class);
                        TraitRegistry.registerMainTraits();
                        this.triggerRegistry.registerCoreMembers();
                        commandRegistry.registerCitizensCommands();
                        ScriptEventRegistry.registerCitizensEvents();
                        new NPCTagBase();
                        ObjectFetcher.registerWithObjectFetcher(NPCTag.class, NPCTag.tagProcessor);
                    }
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            try {
                NoteManager.reload();
                DenizenCore.postLoadScripts();
                Debug.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
                ServerStartScriptEvent.instance.fire();
                this.worldScriptHelper.serverStartEvent();
                if (Settings.allowStupidx()) {
                    Debug.echoError("Don't screw with bad config values.");
                    Bukkit.shutdown();
                }
                Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
                    Debug.outputThisTick = 0;
                    Debug.errorDuplicatePrevention = false;
                    DenizenCore.tick(50);
                }, 1L, 1L);
                InventoryTag.setupInventoryTracker();
                if (!MapTagBasedFlagTracker.skipAllCleanings && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16)) {
                    BukkitWorldScriptHelper.cleanAllWorldChunkFlags();
                }
                Bukkit.getPluginManager().registerEvents((Listener)new PlayerFlagHandler(), (Plugin)this);
                Debug.log("Denizen fully loaded at: " + TimeTag.now().format());
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }, 1L);
        new BukkitRunnable(){

            public void run() {
                if (Settings.canRecordStats()) {
                    new StatsRecord().start();
                }
            }
        }.runTaskTimer((Plugin)this, 100L, 72000L);
        new BukkitRunnable(){

            public void run() {
                PlayerFlagHandler.cleanCache();
            }
        }.runTaskTimer((Plugin)this, 100L, 1200L);
        new BukkitRunnable(){

            public void run() {
                if (!StrongWarning.recentWarnings.isEmpty()) {
                    StringBuilder warnText = new StringBuilder();
                    warnText.append(ChatColor.YELLOW).append("[Denizen] ").append(ChatColor.RED).append("Recent strong system warnings, scripters need to address ASAP (check earlier console logs for details):");
                    for (StrongWarning warning : StrongWarning.recentWarnings) {
                        warnText.append("\n- ").append(warning.message);
                    }
                    StrongWarning.recentWarnings.clear();
                    Bukkit.getConsoleSender().sendMessage(warnText.toString());
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.isOp()) continue;
                        player.sendMessage(warnText.toString());
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 100L, 6000L);
    }

    public void onDisable() {
        if (!this.startedSuccessful) {
            return;
        }
        if (this.hasDisabled) {
            return;
        }
        this.hasDisabled = true;
        DenizenCore.shutdown();
        ScoreboardHelper._saveScoreboards();
        InventoryScriptHelper._savePlayerInventories();
        this.triggerRegistry.disableCoreMembers();
        this.getLogger().log(Level.INFO, " v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        this.saveSaves(false);
        this.worldFlags.shutdown();
    }

    public void reloadConfig() {
        super.reloadConfig();
        Settings.refillCache();
        if (!Settings.showDebug()) {
            this.getLogger().warning("Debug is disabled in the Denizen config. This is almost always a mistake, and should not be done in the majority of cases.");
        }
        SlowWarning.WARNING_RATE = Settings.warningRate();
    }

    public void reloadSaves() {
        if (this.scoreboardsConfigFile == null) {
            this.scoreboardsConfigFile = new File(this.getDataFolder(), "scoreboards.yml");
        }
        this.scoreboardsConfig = YamlConfiguration.loadConfiguration((File)this.scoreboardsConfigFile);
        ScoreboardHelper._recallScoreboards();
        DenizenMapManager.reloadMaps();
        DenizenCore.reloadSaves();
        if (this.worldFlags == null) {
            this.worldFlags = new WorldFlagHandler();
        }
        this.worldFlags.shutdown();
        this.worldFlags.init();
        RunLaterCommand.init(new File(this.getDataFolder(), "run_later.yml").getPath());
        if (new File(this.getDataFolder(), "saves.yml").exists()) {
            LegacySavesUpdater.updateLegacySaves();
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new SavesReloadEvent());
    }

    public FileConfiguration getScoreboards() {
        if (this.scoreboardsConfig == null) {
            this.reloadSaves();
        }
        return this.scoreboardsConfig;
    }

    public void saveSaves(boolean canSleep) {
        ScoreboardHelper._saveScoreboards();
        DenizenMapManager.saveMaps();
        try {
            this.scoreboardsConfig.save(this.scoreboardsConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.scoreboardsConfigFile, ex);
        }
        PlayerFlagHandler.saveAllNow(canSleep);
        this.worldFlags.saveAll();
        RunLaterCommand.saveToFile(canSleep);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String alias, String[] args) {
        String modifier;
        if (cmd.getName().equals("denizenclickable")) {
            UUID id;
            if (args.length != 1 || !(sender instanceof Player)) {
                return false;
            }
            try {
                id = UUID.fromString(args[0]);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            ClickableCommand.runClickable(id, (Player)sender);
            return true;
        }
        String string = modifier = args.length > 0 ? args[0] : "";
        if (!this.commandManager.hasCommand(cmd, modifier) && !modifier.isEmpty()) {
            return this.suggestClosestModifier(sender, cmd.getName(), modifier);
        }
        Object[] methodArgs = new Object[]{sender};
        return this.commandManager.executeSafe(cmd, args, sender, methodArgs);
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        String closest = this.commandManager.getClosestCommandModifier(command, modifier);
        if (!closest.isEmpty()) {
            Messaging.send(sender, "<7>Unknown command. Did you mean:");
            Messaging.send(sender, " /" + command + " " + closest);
            return true;
        }
        return false;
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        if (CoreUtilities.toLowerCase(id).equals("void")) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17)) {
                return new VoidGenerator1_17();
            }
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_16)) {
                return new VoidGenerator();
            }
        }
        return null;
    }

    static {
        versionTag = null;
        supportsPaper = false;
    }
}

