/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;

public class PlayerChangesWorldScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerChangesWorldScriptEvent instance;
    public dWorld origin_world;
    public dWorld destination_world;
    public PlayerChangedWorldEvent event;

    public PlayerChangesWorldScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player changes world");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String s = path.event;
        String lower = path.eventLower;
        List<String> data = CoreUtilities.split(lower, ' ');
        for (int index = 3; index < data.size(); ++index) {
            if (!(data.get(index).equals("from") ? !data.get(index + 1).equals(CoreUtilities.toLowerCase(this.origin_world.getName())) : data.get(index).equals("to") && !data.get(index + 1).equals(CoreUtilities.toLowerCase(this.destination_world.getName())))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "PlayerChangesWorld";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerChangedWorldEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("origin_world")) {
            return this.origin_world;
        }
        if (name.equals("destination_world")) {
            return this.destination_world;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerChangesWorld(PlayerChangedWorldEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.origin_world = new dWorld(event.getFrom());
        this.destination_world = new dWorld(event.getPlayer().getWorld());
        this.event = event;
        this.fire();
    }
}

