/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;

public class EntityCustomName
implements Property {
    public static final String[] handledTags = new String[]{"custom_name_visible", "custom_name"};
    public static final String[] handledMechs = new String[]{"custom_name_visibility", "custom_name_visible", "custom_name"};
    dEntity entity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity;
    }

    public static EntityCustomName getFrom(dObject entity) {
        if (!EntityCustomName.describes(entity)) {
            return null;
        }
        return new EntityCustomName((dEntity)entity);
    }

    private EntityCustomName(dEntity ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        String name = this.entity.getBukkitEntity().getCustomName();
        if (name == null) {
            return null;
        }
        return name;
    }

    @Override
    public String getPropertyId() {
        return "custom_name";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("custom_name_visible") || attribute.startsWith("custom_name.visible")) {
            int fulfilled = 1;
            if (attribute.startsWith("custom_name.visible")) {
                fulfilled = 2;
            }
            return new Element(this.entity.getBukkitEntity().isCustomNameVisible()).getAttribute(attribute.fulfill(fulfilled));
        }
        if (attribute.startsWith("custom_name")) {
            String name = this.entity.getBukkitEntity().getCustomName();
            if (name == null) {
                return null;
            }
            return new Element(name).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("custom_name_visibility") || mechanism.matches("custom_name_visible")) && mechanism.requireBoolean()) {
            this.entity.getBukkitEntity().setCustomNameVisible(mechanism.getValue().asBoolean());
        } else if (mechanism.matches("custom_name")) {
            this.entity.getBukkitEntity().setCustomName(mechanism.getValue().asString());
        }
    }
}

