/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.trade;

import net.aufdemrand.denizen.objects.dTrade;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;

public class TradeHasXp
implements Property {
    public static final String[] handledTags = new String[]{"has_xp"};
    public static final String[] handledMechs = new String[]{"has_xp"};
    private dTrade recipe;

    public static boolean describes(dObject recipe) {
        return recipe instanceof dTrade;
    }

    public static TradeHasXp getFrom(dObject recipe) {
        if (!TradeHasXp.describes(recipe)) {
            return null;
        }
        return new TradeHasXp((dTrade)recipe);
    }

    public TradeHasXp(dTrade recipe) {
        this.recipe = recipe;
    }

    @Override
    public String getPropertyString() {
        if (this.recipe.getRecipe() == null) {
            return null;
        }
        return String.valueOf(this.recipe.getRecipe().hasExperienceReward());
    }

    @Override
    public String getPropertyId() {
        return "has_xp";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_xp")) {
            return new Element(this.recipe.getRecipe().hasExperienceReward()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("has_xp") && mechanism.requireBoolean()) {
            this.recipe.getRecipe().setExperienceReward(mechanism.getValue().asBoolean());
        }
    }
}

