/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import redis.clients.jedis.params.Params;
import redis.clients.jedis.util.SafeEncoder;

public class GeoRadiusStoreParam
extends Params {
    private static final String STORE = "store";
    private static final String STOREDIST = "storedist";

    public static GeoRadiusStoreParam geoRadiusStoreParam() {
        return new GeoRadiusStoreParam();
    }

    public GeoRadiusStoreParam store(String key) {
        if (key != null) {
            this.addParam(STORE, key);
        }
        return this;
    }

    public GeoRadiusStoreParam storeDist(String key) {
        if (key != null) {
            this.addParam(STOREDIST, key);
        }
        return this;
    }

    public byte[] getOption() {
        if (this.contains(STOREDIST)) {
            return SafeEncoder.encode(STOREDIST);
        }
        if (this.contains(STORE)) {
            return SafeEncoder.encode(STORE);
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " must has store or storedist option");
    }

    public byte[] getKey() {
        if (this.contains(STOREDIST)) {
            return SafeEncoder.encode((String)this.getParam(STOREDIST));
        }
        if (this.contains(STORE)) {
            return SafeEncoder.encode((String)this.getParam(STORE));
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " must has store or storedist key");
    }

    public String[] getStringKeys(String key) {
        LinkedList<String> keys = new LinkedList<String>();
        keys.add(key);
        if (this.contains(STORE)) {
            keys.add((String)this.getParam(STORE));
        }
        if (this.contains(STOREDIST)) {
            keys.add((String)this.getParam(STOREDIST));
        }
        return keys.toArray(new String[keys.size()]);
    }

    public byte[][] getByteKeys(byte[] key) {
        LinkedList<byte[]> keys = new LinkedList<byte[]>();
        keys.add(key);
        if (this.contains(STORE)) {
            keys.add(SafeEncoder.encode((String)this.getParam(STORE)));
        }
        if (this.contains(STOREDIST)) {
            keys.add(SafeEncoder.encode((String)this.getParam(STOREDIST)));
        }
        return (byte[][])keys.toArray((T[])new byte[keys.size()][]);
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        Collections.addAll(byteParams, args);
        if (this.contains(STORE)) {
            byteParams.add(SafeEncoder.encode(STORE));
            byteParams.add(SafeEncoder.encode((String)this.getParam(STORE)));
        }
        if (this.contains(STOREDIST)) {
            byteParams.add(SafeEncoder.encode(STOREDIST));
            byteParams.add(SafeEncoder.encode((String)this.getParam(STOREDIST)));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

