/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.EntityType;

public class SpawnCommand
extends AbstractCommand {
    public SpawnCommand() {
        this.setName("spawn");
        this.setSyntax("spawn [<entity>|...] (<location>) (target:<entity>) (persistent)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (EntityType entity : EntityType.values()) {
            addOne.accept(entity.name());
        }
        for (String scriptName : EntityScriptHelper.scripts.keySet()) {
            addOne.accept(scriptName);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                EntityTag.allowDespawnedNpcs = true;
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                EntityTag.allowDespawnedNpcs = false;
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(EntityTag.class) && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("spread") && arg.matchesInteger()) {
                scriptEntry.addObject("spread", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("persistent") && arg.matches("persistent")) {
                scriptEntry.addObject("persistent", "");
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", Utilities.entryDefaultLocation(scriptEntry, false));
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("target");
        ElementTag spread = scriptEntry.getElement("spread");
        boolean persistent = scriptEntry.hasObject("persistent");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), SpawnCommand.db("entities", entities), location, spread, target, persistent ? SpawnCommand.db("persistent", "true") : "");
        }
        ListTag entityList = new ListTag();
        for (EntityTag entity : entities) {
            LocationTag loc = location.clone();
            if (spread != null) {
                loc.add(CoreUtilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt(), 0.0, CoreUtilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt());
            }
            entity.spawnAt(loc);
            entityList.addObject(entity);
            if (!entity.isSpawned()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Failed to spawn " + entity + " (blocked by other plugin, script, or gamerule?).");
                continue;
            }
            if (persistent && entity.isLivingEntity()) {
                entity.getLivingEntity().setRemoveWhenFarAway(false);
            }
            if (target == null) continue;
            entity.target(target.getLivingEntity());
        }
        scriptEntry.addObject("spawned_entities", entityList);
        if (entities.size() != 0) {
            scriptEntry.addObject("spawned_entity", entities.get(0));
        }
    }
}

