/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.npc;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NPCSpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static NPCSpawnScriptEvent instance;
    public NPCTag npc;
    public LocationTag location;
    public NPCSpawnEvent event;

    public NPCSpawnScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("npc spawns");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "NPCSpawn";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, this.npc);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onNPCSpawn(NPCSpawnEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.location = new LocationTag(event.getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

