/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.helpers;

import com.denizenscript.denizen.nms.interfaces.WorldHelper;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_18.impl.BiomeNMSImpl;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;

public class WorldHelperImpl
implements WorldHelper {
    public static MethodHandle DIMENSION_SETTER = ReflectionHelper.getFinalSetter(World.class, ReflectionMappingsInfo.Level_dimension);

    @Override
    public boolean isStatic(org.bukkit.World world) {
        return ((CraftWorld)world).getHandle().y;
    }

    @Override
    public void setStatic(org.bukkit.World world, boolean isStatic) {
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        ReflectionHelper.setFieldValue(World.class, ReflectionMappingsInfo.Level_isClientSide, worldServer, isStatic);
    }

    @Override
    public void setDimension(org.bukkit.World world, World.Environment environment) {
        ResourceKey dimension = null;
        switch (environment) {
            case NORMAL: {
                dimension = World.f;
                break;
            }
            case NETHER: {
                dimension = World.g;
                break;
            }
            case THE_END: {
                dimension = World.h;
            }
        }
        if (dimension != null) {
            try {
                WorldServer worldServer = ((CraftWorld)world).getHandle();
                DIMENSION_SETTER.invoke(worldServer, dimension);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
    }

    @Override
    public float getLocalDifficulty(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().d_(pos);
        return scaler.b();
    }

    @Override
    public Location getNearestBiomeLocation(Location start, BiomeTag biome) {
        BlockPosition result = ((CraftWorld)start.getWorld()).getHandle().a(((BiomeNMSImpl)biome.getBiome()).biomeBase, new BlockPosition(start.getBlockX(), start.getBlockY(), start.getBlockZ()), 6400, 8);
        if (result == null) {
            return null;
        }
        return new Location(start.getWorld(), (double)result.u(), (double)result.v(), (double)result.w());
    }
}

