/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemMendEvent;

public class PlayerMendsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerMendsItemScriptEvent instance;
    public ItemTag item;
    public PlayerItemMendEvent event;
    public LocationTag location;

    public PlayerMendsItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("player mends")) {
            return false;
        }
        return PlayerMendsItemScriptEvent.couldMatchItem(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iItem = path.eventArgLowerAt(2);
        if (!PlayerMendsItemScriptEvent.tryItem(this.item, iItem)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerMendsItem";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.event.setRepairAmount(((ElementTag)determinationObj).asInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return this.item;
            }
            case "repair_amount": {
                return new ElementTag(this.event.getRepairAmount());
            }
            case "xp_orb": {
                return new EntityTag((Entity)this.event.getExperienceOrb());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerItemMend(PlayerItemMendEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.item = new ItemTag(event.getItem());
        this.location = new LocationTag(event.getPlayer().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

