/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.utilities.command.manager.Command;
import com.denizenscript.denizen.utilities.command.manager.CommandContext;
import com.denizenscript.denizen.utilities.command.manager.Paginator;
import com.denizenscript.denizen.utilities.command.manager.exceptions.CommandException;
import com.denizenscript.denizen.utilities.command.manager.messaging.Messaging;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.FutureWarning;
import java.util.Set;
import org.bukkit.command.CommandSender;

public class DenizenCommandHandler {
    @Command(aliases={"denizen"}, usage="submit", desc="Submits recorded logs triggered by /denizen debug -r", modifiers={"submit"}, min=1, max=3, permission="denizen.submit")
    public void submit(CommandContext args, CommandSender sender) throws CommandException {
        if (!com.denizenscript.denizen.utilities.debugging.Debug.record) {
            Messaging.sendError(sender, "Use /denizen debug -r  to record debug information to be submitted");
            return;
        }
        Messaging.send(sender, "Submitting...");
        DenizenCore.implementation.submitRecording(s -> {
            if (s == null) {
                Messaging.sendError(sender, "Error while submitting.");
            } else {
                Messaging.send(sender, "Successfully submitted to " + s);
            }
        });
    }

    @Command(aliases={"denizen"}, usage="debug", desc="Toggles debug mode for Denizen.", modifiers={"debug", "de", "db", "dbug"}, min=1, max=5, permission="denizen.debug", flags="scbrovnipfl")
    public void debug(CommandContext args, CommandSender sender) throws CommandException {
        if (args.hasFlag('s')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            com.denizenscript.denizen.utilities.debugging.Debug.showStackTraces = !com.denizenscript.denizen.utilities.debugging.Debug.showStackTraces;
            Messaging.sendInfo(sender, com.denizenscript.denizen.utilities.debugging.Debug.showStackTraces ? "Denizen debugger is now showing caught exception stack traces." : "Denizen debugger is now hiding caught stacktraces.");
        }
        if (args.hasFlag('c')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            com.denizenscript.denizen.utilities.debugging.Debug.showColor = !com.denizenscript.denizen.utilities.debugging.Debug.showColor;
            Messaging.sendInfo(sender, com.denizenscript.denizen.utilities.debugging.Debug.showColor ? "Denizen debugger is now showing color." : "Denizen debugger color has been disabled.");
        }
        if (args.hasFlag('o')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            com.denizenscript.denizen.utilities.debugging.Debug.debugOverride = !com.denizenscript.denizen.utilities.debugging.Debug.debugOverride;
            Messaging.sendInfo(sender, com.denizenscript.denizen.utilities.debugging.Debug.debugOverride ? "Denizen debugger is now overriding 'debug: false'." : "Denizen debugger override has been disabled.");
        }
        if (args.hasFlag('b')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            Debug.showScriptBuilder = !Debug.showScriptBuilder;
            Messaging.sendInfo(sender, Debug.showScriptBuilder ? "Denizen debugger is now logging the ScriptBuilder." : "Denizen debugger is now hiding ScriptBuilder logging.");
        }
        if (args.hasFlag('r')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            com.denizenscript.denizen.utilities.debugging.Debug.record = !com.denizenscript.denizen.utilities.debugging.Debug.record;
            com.denizenscript.denizen.utilities.debugging.Debug.recording = new StringBuilder();
            Messaging.sendInfo(sender, com.denizenscript.denizen.utilities.debugging.Debug.record ? "Denizen debugger is now recording. Use /denizen submit to finish." : "Denizen debugger recording disabled.");
        }
        if (args.hasFlag('v')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            Debug.verbose = !Debug.verbose;
            Messaging.sendInfo(sender, Debug.verbose ? "Denizen debugger is now verbose." : "Denizen debugger verbosity disabled.");
        }
        if (args.hasFlag('f')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            FutureWarning.futureWarningsEnabled = !FutureWarning.futureWarningsEnabled;
            Messaging.sendInfo(sender, FutureWarning.futureWarningsEnabled ? "Denizen debugger is now showing future warnings." : "Denizen debugger future-warnings disabled.");
        }
        if (args.hasFlag('n')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            com.denizenscript.denizen.utilities.debugging.Debug.shouldTrim = !com.denizenscript.denizen.utilities.debugging.Debug.shouldTrim;
            Messaging.sendInfo(sender, com.denizenscript.denizen.utilities.debugging.Debug.shouldTrim ? "Denizen debugger is now trimming long messages." : "Denizen debugger is no longer trimming long messages.");
        }
        if (args.hasFlag('i')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            com.denizenscript.denizen.utilities.debugging.Debug.showSources = !com.denizenscript.denizen.utilities.debugging.Debug.showSources;
            Messaging.sendInfo(sender, com.denizenscript.denizen.utilities.debugging.Debug.showSources ? "Denizen debugger is now showing source information." : "Denizen debugger is no longer showing source information.");
        }
        if (args.hasFlag('p')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            NetworkInterceptHelper.enable();
            NMSHandler.debugPackets = !NMSHandler.debugPackets;
            NMSHandler.debugPacketFilter = "";
            Messaging.sendInfo(sender, NMSHandler.debugPackets ? "Denizen debugger is now showing unfiltered packet logs." : "Denizen debugger is no longer showing packet logs.");
        }
        if (args.hasValueFlag("pfilter")) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            NetworkInterceptHelper.enable();
            NMSHandler.debugPackets = true;
            NMSHandler.debugPacketFilter = CoreUtilities.toLowerCase(args.getFlag("pfilter"));
            Messaging.sendInfo(sender, "Denizen debug packet log now enabled and filtered.");
            return;
        }
        if (args.hasFlag('l')) {
            if (!com.denizenscript.denizen.utilities.debugging.Debug.showDebug) {
                com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            }
            Debug.showLoading = !Debug.showLoading;
            Messaging.sendInfo(sender, Debug.showLoading ? "Denizen debugger is now showing script loading information." : "Denizen debugger is no longer showing script loading information.");
        }
        if (args.getFlags().isEmpty()) {
            com.denizenscript.denizen.utilities.debugging.Debug.toggle();
            Messaging.sendInfo(sender, "Denizen debugger is now: " + (com.denizenscript.denizen.utilities.debugging.Debug.showDebug ? "<a>ENABLED" : "<c>DISABLED"));
        }
    }

    @Command(aliases={"denizen"}, usage="do_nothing", desc="Does nothing, for better server command handling", modifiers={"do_nothing"}, min=1, max=3, permission="denizen.basic")
    public void do_nothing(CommandContext args, CommandSender sender) throws CommandException {
    }

    @Command(aliases={"denizen"}, usage="version", desc="Shows the currently loaded version of Denizen.", modifiers={"version"}, min=1, max=3, permission="denizen.basic")
    public void version(CommandContext args, CommandSender sender) throws CommandException {
        Messaging.sendInfo(sender, "<2>DENIZEN<7>: scriptable Minecraft!");
        Messaging.send(sender, "");
        Messaging.send(sender, "<7>by: <f>the DenizenScript team, with help from many skilled contributors!");
        Messaging.send(sender, "<7>chat with us at: <f> https://discord.gg/Q6pZGSR");
        Messaging.send(sender, "<7>or learn more at: <f> https://denizenscript.com");
        Messaging.send(sender, "<7>version: <f>" + Denizen.versionTag + "<7>, core version: <f>" + DenizenCore.VERSION);
    }

    @Command(aliases={"denizen"}, usage="save", desc="Saves the current Denizen save data to file as needed.", modifiers={"save"}, min=1, max=3, permission="denizen.basic")
    public void save(CommandContext args, CommandSender sender) throws CommandException {
        DenizenCore.saveAll();
        Denizen.getInstance().saveSaves(true);
        Messaging.send(sender, "Denizen save data saved to disk from memory.");
    }

    @Command(aliases={"denizen"}, usage="reload (saves|notes|config|scripts) (-a)", desc="Reloads various Denizen files from disk to memory.", modifiers={"reload"}, min=1, max=3, permission="denizen.basic", flags="a")
    public void reload(CommandContext args, CommandSender sender) throws CommandException {
        if (args.hasFlag('a')) {
            Denizen.getInstance().reloadConfig();
            DenizenCore.reloadScripts();
            NoteManager.reload();
            Denizen.getInstance().reloadSaves();
            Messaging.send(sender, "Denizen save data, config, and scripts reloaded from disk to memory.");
            if (ScriptHelper.hadError()) {
                Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
            }
            return;
        }
        if (args.length() > 2) {
            if (args.getString(1).equalsIgnoreCase("saves")) {
                Denizen.getInstance().reloadSaves();
                Messaging.send(sender, "Denizen save data reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("notes")) {
                NoteManager.reload();
                Messaging.send(sender, "Denizen note data reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("config")) {
                Denizen.getInstance().reloadConfig();
                Messaging.send(sender, "Denizen config file reloaded from disk to memory.");
                return;
            }
            if (args.getString(1).equalsIgnoreCase("scripts")) {
                DenizenCore.reloadScripts();
                Messaging.send(sender, "Denizen/scripts/... reloaded from disk to memory.");
                if (ScriptHelper.hadError()) {
                    Messaging.sendError(sender, "There was an error loading your scripts, check the console for details!");
                }
                Messaging.sendError(sender, "'/denizen reload scripts' is the old way of doing things ... use '/ex reload' instead!");
                return;
            }
        }
        Messaging.send(sender, "");
        Messaging.send(sender, "<f>Specify which parts to reload. Valid options are: SAVES, NOTES, CONFIG, SCRIPTS");
        Messaging.send(sender, "<b>Example: /denizen reload scripts");
        Messaging.send(sender, "<f>Use '-a' to reload all parts.");
        Messaging.send(sender, "");
    }

    @Command(aliases={"denizen"}, usage="scripts (--type assignment|task|...) (--filter string)", desc="Lists currently loaded dScripts.", modifiers={"scripts"}, min=1, max=4, permission="denizen.basic")
    public void scripts(CommandContext args, CommandSender sender) throws CommandException {
        String type = null;
        if (args.hasValueFlag("type")) {
            type = args.getFlag("type");
        }
        String filter = null;
        if (args.hasValueFlag("filter")) {
            filter = args.getFlag("filter");
        }
        Set<String> scripts = ScriptRegistry.scriptContainers.keySet();
        Paginator paginator = new Paginator().header("Scripts");
        paginator.addLine("<e>Key: <a>Type  <b>Name");
        for (String script : scripts) {
            Object scriptContainer = ScriptRegistry.getScriptContainer(script);
            if (type != null) {
                if (!((ScriptContainer)scriptContainer).getContainerType().equalsIgnoreCase(type)) continue;
                if (filter != null) {
                    if (!script.contains(filter.toUpperCase())) continue;
                    paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                    continue;
                }
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            if (filter != null) {
                if (!script.contains(filter.toUpperCase())) continue;
                paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
                continue;
            }
            paginator.addLine("<a>" + ((ScriptContainer)scriptContainer).getContainerType().substring(0, 3) + "  <b>" + script);
        }
        if (!paginator.sendPage(sender, args.getInteger(1, 1))) {
            throw new CommandException("The page " + args.getInteger(1, 1) + " does not exist.");
        }
    }
}

