/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.event.Listener;

public class ZapCommand
extends AbstractCommand
implements Listener {
    public ZapCommand() {
        this.setName("zap");
        this.setSyntax("zap (<script>) [<step>] (<duration>)");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addScriptsOfType(InteractScriptContainer.class);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("script") && !scriptEntry.hasObject("step") && arg.hasPrefix() && arg.getPrefix().matchesArgumentType(ScriptTag.class)) {
                Deprecations.zapPrefix.warn(scriptEntry);
                scriptEntry.addObject("script", arg.getPrefix().asType(ScriptTag.class));
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(ScriptTag.class) && arg.asType(ScriptTag.class).getContainer() instanceof InteractScriptContainer && arg.limitToOnlyPrefix("script")) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("step") && arg.limitToOnlyPrefix("step")) {
                scriptEntry.addObject("step", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(DurationTag.class) && arg.limitToOnlyPrefix("duration")) {
                scriptEntry.addObject("duration", arg.asType(DurationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        if (player == null || !player.isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
        if (!scriptEntry.hasObject("script")) {
            NPCTag npc;
            ScriptTag script = scriptEntry.getScript();
            if (script != null) {
                InteractScriptContainer interact;
                if (script.getContainer() instanceof InteractScriptContainer) {
                    scriptEntry.addObject("script", script);
                } else if (script.getContainer() instanceof AssignmentScriptContainer && (interact = ((AssignmentScriptContainer)script.getContainer()).interact) != null) {
                    scriptEntry.addObject("script", new ScriptTag(interact));
                }
            }
            if (!scriptEntry.hasObject("script") && (npc = Utilities.getEntryNPC(scriptEntry)) != null && npc.getCitizen().hasTrait(AssignmentTrait.class)) {
                AssignmentTrait trait = (AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class);
                for (AssignmentScriptContainer container : trait.containerCache) {
                    if (container == null || container.getInteract() == null) continue;
                    scriptEntry.addObject("script", new ScriptTag(container.getInteract()));
                    break;
                }
            }
            if (!scriptEntry.hasObject("script")) {
                throw new InvalidArgumentsException("No script to zap! Must be in an interact script, or have a linked NPC with an associated interact script.");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        DurationTag duration = (DurationTag)scriptEntry.getObjectTag("duration");
        ElementTag stepElement = scriptEntry.getElement("step");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), Utilities.getEntryPlayer(scriptEntry), script, stepElement != null ? stepElement : ZapCommand.db("step", "++ (inc)"), duration);
        }
        String step = stepElement == null ? null : stepElement.asString();
        String currentStep = InteractScriptHelper.getCurrentStep(Utilities.getEntryPlayer(scriptEntry), script.getName());
        if (step == null) {
            step = ArgumentHelper.matchesInteger(currentStep) ? String.valueOf(Integer.parseInt(currentStep) + 1) : "1";
        } else if (step.equals("*")) {
            step = ((InteractScriptContainer)script.getContainer()).getDefaultStepName();
        }
        if (step.equalsIgnoreCase(currentStep)) {
            Debug.echoError(scriptEntry, "Zapping to own current step!");
            return;
        }
        TimeTag expiration = null;
        if (duration != null && duration.getSeconds() > 0.0) {
            expiration = new TimeTag(TimeTag.now().millis() + duration.getMillis());
        }
        Utilities.getEntryPlayer(scriptEntry).getFlagTracker().setFlag("__interact_step." + script.getName(), new ElementTag(step), expiration);
    }
}

