/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.core.AdjustCommand;
import com.denizenscript.denizencore.scripts.commands.core.CustomEventCommand;
import com.denizenscript.denizencore.scripts.commands.core.DebugCommand;
import com.denizenscript.denizencore.scripts.commands.core.DebugInvalidCommand;
import com.denizenscript.denizencore.scripts.commands.core.EventCommand;
import com.denizenscript.denizencore.scripts.commands.core.FlagCommand;
import com.denizenscript.denizencore.scripts.commands.core.NoteCommand;
import com.denizenscript.denizencore.scripts.commands.core.RedisCommand;
import com.denizenscript.denizencore.scripts.commands.core.ReloadCommand;
import com.denizenscript.denizencore.scripts.commands.core.SQLCommand;
import com.denizenscript.denizencore.scripts.commands.core.WebGetCommand;
import com.denizenscript.denizencore.scripts.commands.core.WebServerCommand;
import com.denizenscript.denizencore.scripts.commands.file.FileCopyCommand;
import com.denizenscript.denizencore.scripts.commands.file.LogCommand;
import com.denizenscript.denizencore.scripts.commands.file.YamlCommand;
import com.denizenscript.denizencore.scripts.commands.queue.ChooseCommand;
import com.denizenscript.denizencore.scripts.commands.queue.DefineCommand;
import com.denizenscript.denizencore.scripts.commands.queue.DefineMapCommand;
import com.denizenscript.denizencore.scripts.commands.queue.DetermineCommand;
import com.denizenscript.denizencore.scripts.commands.queue.ElseCommand;
import com.denizenscript.denizencore.scripts.commands.queue.ForeachCommand;
import com.denizenscript.denizencore.scripts.commands.queue.GotoCommand;
import com.denizenscript.denizencore.scripts.commands.queue.IfCommand;
import com.denizenscript.denizencore.scripts.commands.queue.InjectCommand;
import com.denizenscript.denizencore.scripts.commands.queue.MarkCommand;
import com.denizenscript.denizencore.scripts.commands.queue.QueueCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RandomCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RateLimitCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RepeatCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RunCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RunLaterCommand;
import com.denizenscript.denizencore.scripts.commands.queue.StopCommand;
import com.denizenscript.denizencore.scripts.commands.queue.WaitCommand;
import com.denizenscript.denizencore.scripts.commands.queue.WaitUntilCommand;
import com.denizenscript.denizencore.scripts.commands.queue.WhileCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.Map;

public abstract class CommandRegistry {
    public static final DebugInvalidCommand debugInvalidCommand = new DebugInvalidCommand();
    public final Map<String, AbstractCommand> instances = new HashMap<String, AbstractCommand>();
    public final Map<Class<? extends AbstractCommand>, String> classes = new HashMap<Class<? extends AbstractCommand>, String>();

    public void register(String commandName, AbstractCommand commandInstance) {
        this.instances.put(CoreUtilities.toLowerCase(commandName), commandInstance);
        this.classes.put(commandInstance.getClass(), CoreUtilities.toLowerCase(commandName));
    }

    public Map<String, AbstractCommand> list() {
        return this.instances;
    }

    public AbstractCommand get(String commandName) {
        return this.instances.get(CoreUtilities.toLowerCase(commandName));
    }

    public <T extends AbstractCommand> T get(Class<T> clazz) {
        String command = this.classes.get(clazz);
        if (command != null) {
            return (T)((AbstractCommand)clazz.cast(this.instances.get(command)));
        }
        return null;
    }

    public void registerCoreCommands() {
        this.registerCommand(AdjustCommand.class);
        this.registerCommand(CustomEventCommand.class);
        this.registerCommand(DebugCommand.class);
        this.registerCommand(EventCommand.class);
        this.registerCommand(FlagCommand.class);
        this.registerCommand(NoteCommand.class);
        this.registerCommand(ReloadCommand.class);
        this.registerCommand(SQLCommand.class);
        this.registerCommand(RedisCommand.class);
        this.registerCommand(WebGetCommand.class);
        this.registerCommand(WebServerCommand.class);
        this.registerCommand(FileCopyCommand.class);
        this.registerCommand(LogCommand.class);
        this.registerCommand(YamlCommand.class);
        this.registerCommand(ChooseCommand.class);
        this.registerCommand(DefineCommand.class);
        this.registerCommand(DefineMapCommand.class);
        this.registerCommand(DetermineCommand.class);
        this.registerCommand(ElseCommand.class);
        this.registerCommand(ForeachCommand.class);
        this.registerCommand(GotoCommand.class);
        this.registerCommand(IfCommand.class);
        this.registerCommand(InjectCommand.class);
        this.registerCommand(MarkCommand.class);
        this.registerCommand(QueueCommand.class);
        this.registerCommand(RandomCommand.class);
        this.registerCommand(RateLimitCommand.class);
        this.registerCommand(RepeatCommand.class);
        this.registerCommand(RunCommand.class);
        this.registerCommand(RunLaterCommand.class);
        this.registerCommand(StopCommand.class);
        this.registerCommand(WaitCommand.class);
        this.registerCommand(WaitUntilCommand.class);
        this.registerCommand(WhileCommand.class);
    }

    public <T extends AbstractCommand> void registerCommand(Class<T> cmd) {
        try {
            AbstractCommand command = (AbstractCommand)cmd.newInstance();
            this.register(command.getName(), command);
        }
        catch (Throwable e) {
            Debug.echoError("Could not register command " + cmd.getName() + ", exception follows...");
            Debug.echoError(e);
        }
    }

    public void disableCoreMembers() {
        for (AbstractCommand member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                Debug.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                Debug.echoError(e);
            }
        }
    }
}

