/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.MapScriptContainer;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.maps.DenizenMapRenderer;
import com.denizenscript.denizen.utilities.maps.MapDot;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class MapCommand
extends AbstractCommand {
    public MapCommand() {
        this.setName("map");
        this.setSyntax("map [<#>/new:<world>] (reset:<location>) (scale:<value>) (tracking) (image:<file>) (resize) (script:<script>) (dot:<color>) (radius:<radius>) (x:<#>) (y:<#>)");
        this.setRequiredArguments(2, 9);
        this.isProcedural = false;
        this.setPrefixesHandled("dot", "radius", "image", "script", "x", "y", "reset", "new");
        this.setBooleansHandled("resize", "tracking");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("map-id") && arg.matchesInteger()) {
                scriptEntry.addObject("map-id", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DenizenMapRenderer dmr;
        MapView map;
        ElementTag id = scriptEntry.getElement("map-id");
        WorldTag create = scriptEntry.argForPrefix("new", WorldTag.class, true);
        LocationTag resetLoc = scriptEntry.argForPrefix("reset", LocationTag.class, true);
        ElementTag image = scriptEntry.argForPrefixAsElement("image", null);
        boolean resize = scriptEntry.argAsBoolean("resize");
        ScriptTag script = scriptEntry.argForPrefix("script", ScriptTag.class, true);
        ElementTag width = scriptEntry.argForPrefixAsElement("width", null);
        ElementTag height = scriptEntry.argForPrefixAsElement("height", null);
        ElementTag scale = scriptEntry.argForPrefixAsElement("scale", null);
        boolean tracking = scriptEntry.argAsBoolean("tracking");
        ElementTag x = scriptEntry.argForPrefixAsElement("x", "0");
        ElementTag y = scriptEntry.argForPrefixAsElement("y", "0");
        ColorTag dot = scriptEntry.argForPrefix("dot", ColorTag.class, true);
        ElementTag radius = scriptEntry.argForPrefixAsElement("radius", null);
        if (!x.isFloat() || !y.isFloat()) {
            throw new InvalidArgumentsRuntimeException("Invalid X or Y value!");
        }
        if (scale != null && !scale.matchesEnum(MapView.Scale.class)) {
            throw new InvalidArgumentsRuntimeException("Invalid scale - doesn't match scale enum!");
        }
        if (create == null && id == null) {
            throw new InvalidArgumentsRuntimeException("Must specify a map ID or create a new map!");
        }
        if (resetLoc == null && image == null && script == null && dot == null) {
            throw new InvalidArgumentsRuntimeException("Must specify a valid action to perform!");
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), id, create, resetLoc, image, script, dot, radius, scale, MapCommand.db("resize", resize), MapCommand.db("tracking", tracking), width, height, x, y);
        }
        if (create != null) {
            map = Bukkit.getServer().createMap(create.getWorld());
            scriptEntry.addObject("created_map", new ElementTag(map.getId()));
            Debug.echoDebug((Debuggable)scriptEntry, "Created map with id " + map.getId() + ".");
        } else {
            map = Bukkit.getServer().getMap((int)((short)id.asInt()));
            if (map == null) {
                Debug.echoError("No map found for ID '" + id.asInt() + "'!");
                return;
            }
        }
        if (resetLoc != null) {
            map.setTrackingPosition(tracking);
            if (scale != null) {
                map.setScale(MapView.Scale.valueOf((String)scale.asString().toUpperCase()));
            }
            List<MapRenderer> oldRenderers = DenizenMapManager.removeDenizenRenderers(map);
            for (MapRenderer renderer : oldRenderers) {
                map.addRenderer(renderer);
            }
            map.setCenterX(resetLoc.getBlockX());
            map.setCenterZ(resetLoc.getBlockZ());
            map.setWorld(resetLoc.getWorld());
        }
        if (script != null) {
            DenizenMapManager.removeDenizenRenderers(map);
            ((MapScriptContainer)script.getContainer()).applyTo(map);
        }
        if (image != null) {
            int high;
            int wide;
            dmr = DenizenMapManager.getDenizenRenderer(map);
            int n = width != null ? width.asInt() : (wide = resize ? 128 : 0);
            int n2 = height != null ? height.asInt() : (high = resize ? 128 : 0);
            if (CoreUtilities.toLowerCase(image.asString()).endsWith(".gif")) {
                dmr.autoUpdate = true;
            }
            dmr.addObject(new MapImage(dmr, x.asString(), y.asString(), "true", false, image.asString(), wide, high));
            dmr.hasChanged = true;
        }
        if (dot != null) {
            dmr = DenizenMapManager.getDenizenRenderer(map);
            dmr.addObject(new MapDot(x.asString(), y.asString(), "true", false, radius == null ? "1" : radius.toString(), dot.toString()));
            dmr.hasChanged = true;
        }
    }
}

