/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.item.ItemPotion;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityPotionEffects
implements Property {
    public static final String[] handledMechs = new String[]{"potion_effects"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)object).isLivingEntity() || ((EntityTag)object).getBukkitEntity() instanceof Arrow;
    }

    public static EntityPotionEffects getFrom(ObjectTag object) {
        if (!EntityPotionEffects.describes(object)) {
            return null;
        }
        return new EntityPotionEffects((EntityTag)object);
    }

    private EntityPotionEffects(EntityTag entity) {
        this.entity = entity;
    }

    public Collection<PotionEffect> getEffectsList() {
        if (this.entity.isLivingEntity()) {
            return this.entity.getLivingEntity().getActivePotionEffects();
        }
        if (this.isArrow()) {
            return this.getArrow().getCustomEffects();
        }
        return new ArrayList<PotionEffect>();
    }

    public ListTag getEffectsListTag() {
        ListTag result = new ListTag();
        for (PotionEffect effect : this.getEffectsList()) {
            result.add(ItemPotion.stringifyEffect(effect));
        }
        return result;
    }

    public ListTag getEffectsMapTag() {
        ListTag result = new ListTag();
        for (PotionEffect effect : this.getEffectsList()) {
            result.addObject(ItemPotion.effectToMap(effect));
        }
        return result;
    }

    public boolean isArrow() {
        return this.entity.getBukkitEntity() instanceof Arrow;
    }

    public Arrow getArrow() {
        return (Arrow)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        ListTag effects = this.getEffectsMapTag();
        return effects.isEmpty() ? null : effects.identify();
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    public static void registerTags() {
        PropertyParser.registerTag(ListTag.class, "list_effects", (attribute, object) -> {
            Deprecations.oldPotionEffects.warn(attribute.context);
            return object.getEffectsListTag();
        }, new String[0]);
        PropertyParser.registerTag(ListTag.class, "effects_data", (attribute, object) -> object.getEffectsMapTag(), new String[0]);
        PropertyParser.registerTag(ElementTag.class, "has_effect", (attribute, object) -> {
            boolean returnElement = false;
            if (attribute.hasParam()) {
                PotionEffectType effectType = PotionEffectType.getByName((String)attribute.getParam());
                if (effectType == null) {
                    attribute.echoError("Invalid effect type specified: " + attribute.getParam());
                    return null;
                }
                if (object.entity.isLivingEntity()) {
                    returnElement = object.entity.getLivingEntity().hasPotionEffect(effectType);
                } else if (object.isArrow()) {
                    returnElement = object.getArrow().hasCustomEffect(effectType);
                }
            } else if (!object.getEffectsList().isEmpty()) {
                returnElement = true;
            }
            return new ElementTag(returnElement);
        }, new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion_effects")) {
            for (ObjectTag effectObj : CoreUtilities.objectToList(mechanism.value, mechanism.context)) {
                PotionEffect effect;
                if (effectObj.canBeType(MapTag.class)) {
                    MapTag effectMap = effectObj.asType(MapTag.class, mechanism.context);
                    effect = ItemPotion.parseEffect(effectMap, mechanism.context);
                } else {
                    String effectStr = effectObj.toString();
                    effect = ItemPotion.parseEffect(effectStr, mechanism.context);
                }
                if (effect == null) {
                    mechanism.echoError("Invalid potion effect '" + effectObj + "'");
                    continue;
                }
                if (this.entity.isLivingEntity()) {
                    this.entity.getLivingEntity().addPotionEffect(effect);
                    continue;
                }
                if (!this.isArrow()) continue;
                this.getArrow().addCustomEffect(effect, true);
            }
        }
    }
}

