/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.material.MaterialDirectional;
import com.denizenscript.denizen.objects.properties.material.MaterialDistance;
import com.denizenscript.denizen.objects.properties.material.MaterialHalf;
import com.denizenscript.denizen.objects.properties.material.MaterialSwitchFace;
import com.denizenscript.denizen.scripts.commands.world.SwitchCommand;
import com.denizenscript.denizen.utilities.AdvancedTextImpl;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.NotedAreaTracker;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.blocks.SpawnableHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.flags.DataPersistenceFlagTracker;
import com.denizenscript.denizen.utilities.flags.LocationFlagSearchHelper;
import com.denizenscript.denizen.utilities.world.PathFinder;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.SimplexNoise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Beacon;
import org.bukkit.block.Beehive;
import org.bukkit.block.Bell;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Campfire;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.block.EndGateway;
import org.bukkit.block.Furnace;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Lectern;
import org.bukkit.block.Lockable;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.Structure;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;
import org.bukkit.material.Attachable;
import org.bukkit.material.MaterialData;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class LocationTag
extends Location
implements ObjectTag,
Notable,
Adjustable,
FlaggableObject {
    public String backupWorld;
    String prefix = "Location";
    public static ObjectTagProcessor<LocationTag> tagProcessor = new ObjectTagProcessor();

    public String getWorldName() {
        if (this.backupWorld != null) {
            return this.backupWorld;
        }
        World w = super.getWorld();
        if (w != null) {
            return w.getName();
        }
        return null;
    }

    public World getWorld() {
        World w = super.getWorld();
        if (w != null) {
            return w;
        }
        if (this.backupWorld == null) {
            return null;
        }
        super.setWorld(Bukkit.getWorld((String)this.backupWorld));
        return super.getWorld();
    }

    public LocationTag clone() {
        return (LocationTag)super.clone();
    }

    @Override
    public void makeUnique(String id) {
        NoteManager.saveAs(this, id);
    }

    @Override
    @Note(value="Locations")
    public String getSaveObject() {
        return this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getPitch() + "," + this.getYaw() + "," + this.getWorldName();
    }

    public static String getSaved(LocationTag location) {
        return NoteManager.getSavedId(location);
    }

    @Override
    public void forget() {
        NoteManager.remove(this);
    }

    @Deprecated
    public static LocationTag valueOf(String string) {
        return LocationTag.valueOf(string, null);
    }

    @Fetchable(value="l")
    public static LocationTag valueOf(String string, TagContext context) {
        Notable noted;
        if (string == null) {
            return null;
        }
        if (string.startsWith("l@")) {
            string = string.substring(2);
        }
        if ((noted = NoteManager.getSavedObject(string)) instanceof LocationTag) {
            return (LocationTag)noted;
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() == 2) {
            try {
                return new LocationTag(null, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)));
            }
            catch (Exception e) {
                if (context == null || context.showErrors()) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 3) {
            try {
                World world;
                String worldName = split.get(2);
                if (worldName.startsWith("w@")) {
                    worldName = worldName.substring("w@".length());
                }
                if ((world = Bukkit.getWorld((String)worldName)) != null) {
                    return new LocationTag(world, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)));
                }
                if (ArgumentHelper.matchesDouble(split.get(2))) {
                    return new LocationTag(null, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)), Double.parseDouble(split.get(2)));
                }
                LocationTag output = new LocationTag(null, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)));
                output.backupWorld = worldName;
                return output;
            }
            catch (Exception e) {
                if (context == null || context.showErrors()) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 4) {
            try {
                World world;
                String worldName = split.get(3);
                if (worldName.startsWith("w@")) {
                    worldName = worldName.substring("w@".length());
                }
                if ((world = Bukkit.getWorld((String)worldName)) != null) {
                    return new LocationTag(world, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)), Double.parseDouble(split.get(2)));
                }
                LocationTag output = new LocationTag(null, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)), Double.parseDouble(split.get(2)));
                output.backupWorld = worldName;
                return output;
            }
            catch (Exception e) {
                if (context == null || context.showErrors()) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 5) {
            try {
                float pitch = Float.parseFloat(split.get(3));
                float yaw = Float.parseFloat(split.get(4));
                return new LocationTag((World)null, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)), Double.parseDouble(split.get(2)), yaw, pitch);
            }
            catch (Exception e) {
                if (context == null || context.showErrors()) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (split.size() == 6) {
            try {
                String worldName = split.get(5);
                if (worldName.startsWith("w@")) {
                    worldName = worldName.substring("w@".length());
                }
                float pitch = Float.parseFloat(split.get(3));
                float yaw = Float.parseFloat(split.get(4));
                return new LocationTag(worldName, Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)), Double.parseDouble(split.get(2)), yaw, pitch);
            }
            catch (Exception e) {
                if (context == null || context.showErrors()) {
                    Debug.log("Minor: valueOf LocationTag returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                }
                return null;
            }
        }
        if (context == null || context.showErrors()) {
            Debug.log("Minor: valueOf LocationTag returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.startsWith("l@")) {
            return true;
        }
        return LocationTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    @Override
    public ObjectTag duplicate() {
        return this.clone();
    }

    public LocationTag(Location location) {
        this(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        if (location instanceof LocationTag) {
            this.backupWorld = ((LocationTag)location).backupWorld;
        }
    }

    public LocationTag(Vector vector) {
        this((World)null, vector.getX(), vector.getY(), vector.getZ(), 0.0f, 0.0f);
    }

    public LocationTag(World world, Vector vector) {
        this(world, vector.getX(), vector.getY(), vector.getZ(), 0.0f, 0.0f);
    }

    public LocationTag(World world, double x, double y) {
        this(world, x, y, 0.0);
    }

    public LocationTag(World world, double x, double y, double z) {
        this(world, x, y, z, 0.0f, 0.0f);
    }

    public LocationTag(double x, double y, double z, String worldName) {
        super(worldName == null ? null : Bukkit.getWorld((String)worldName), x, y, z);
        this.backupWorld = worldName;
    }

    public LocationTag(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, EntityHelper.normalizeYaw(yaw), pitch);
        if (world != null) {
            this.backupWorld = world.getName();
        }
    }

    public LocationTag(String worldName, double x, double y, double z, float yaw, float pitch) {
        super(worldName == null ? null : Bukkit.getWorld((String)worldName), x, y, z, EntityHelper.normalizeYaw(yaw), pitch);
        this.backupWorld = worldName;
    }

    public boolean isChunkLoaded() {
        return this.getWorld() != null && this.getWorld().isChunkLoaded(this.getBlockX() >> 4, this.getBlockZ() >> 4);
    }

    public boolean isChunkLoadedSafe() {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
            boolean bl = this.isChunkLoaded();
            return bl;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public Block getBlock() {
        if (this.getWorld() == null) {
            Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
            return null;
        }
        return super.getBlock();
    }

    public Block getBlockForTag(Attribute attribute) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Block block = null;
                return block;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Block block = null;
                return block;
            }
            Block block = super.getBlock();
            return block;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public BlockData getBlockDataForTag(Attribute attribute) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                BlockData blockData = null;
                return blockData;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                BlockData blockData = null;
                return blockData;
            }
            BlockData blockData = super.getBlock().getBlockData();
            return blockData;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public Material getBlockTypeForTag(Attribute attribute) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Material material = null;
                return material;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Material material = null;
                return material;
            }
            Material material = super.getBlock().getType();
            return material;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public static BlockState getBlockStateSafe(Block block) {
        NMSHandler.chunkHelper.changeChunkServerThread(block.getWorld());
        try {
            BlockState blockState = block.getState();
            return blockState;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(block.getWorld());
        }
    }

    public BiomeNMS getBiome() {
        return NMSHandler.instance.getBiomeAt(super.getBlock());
    }

    public BiomeNMS getBiomeForTag(Attribute attribute) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                BiomeNMS biomeNMS = null;
                return biomeNMS;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                BiomeNMS biomeNMS = null;
                return biomeNMS;
            }
            BiomeNMS biomeNMS = this.getBiome();
            return biomeNMS;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public Location getHighestBlockForTag(Attribute attribute) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Location location = null;
                return location;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Location location = null;
                return location;
            }
            Location location = this.getWorld().getHighestBlockAt((Location)this).getLocation();
            return location;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ItemStack> getDropsForTag(Attribute attribute, ItemStack item) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                Collection<ItemStack> collection = null;
                return collection;
            }
            Collection collection = item == null ? super.getBlock().getDrops() : super.getBlock().getDrops(item);
            return collection;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpDropForTag(Attribute attribute, ItemStack item) {
        NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
        try {
            if (this.getWorld() == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                }
                int n = 0;
                return n;
            }
            if (!this.isChunkLoaded()) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                }
                int n = 0;
                return n;
            }
            int n = NMSHandler.blockHelper.getExpDrop(super.getBlock(), item);
            return n;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public BlockState getBlockState() {
        return this.getBlock().getState();
    }

    public BlockState getBlockStateForTag(Attribute attribute) {
        Block block = this.getBlockForTag(attribute);
        if (block == null) {
            return null;
        }
        return LocationTag.getBlockStateSafe(block);
    }

    public static boolean isSameBlock(Location a, Location b) {
        return a != null && b != null && a.getWorld() == b.getWorld() && a.getBlockX() == b.getBlockX() && a.getBlockY() == b.getBlockY() && a.getBlockZ() == b.getBlockZ();
    }

    public LocationTag getBlockLocation() {
        return new LocationTag(this.getWorld(), (double)this.getBlockX(), (double)this.getBlockY(), this.getBlockZ());
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        if (this.getWorld() == null) {
            return null;
        }
        return new DataPersistenceFlagTracker((PersistentDataHolder)this.getChunk(), "flag_tracker_" + this.getBlockX() + "_" + this.getBlockY() + "_" + this.getBlockZ() + "_");
    }

    @Override
    public AbstractFlagTracker getFlagTrackerForTag() {
        if (!this.isChunkLoadedSafe()) {
            return null;
        }
        return this.getFlagTracker();
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    @Override
    public String getReasonNotFlaggable() {
        if (this.getWorld() == null) {
            return "missing world";
        }
        if (!this.isChunkLoadedSafe()) {
            return "chunk is not loaded";
        }
        return "unknown reason";
    }

    public void setPitch(float pitch) {
        super.setPitch(pitch);
    }

    public void setYaw(float yaw) {
        super.setYaw(yaw);
    }

    public LocationTag add(double x, double y, double z) {
        super.add(x, y, z);
        return this;
    }

    public LocationTag add(Vector input) {
        super.add(input);
        return this;
    }

    public LocationTag add(Location input) {
        super.add(input.getX(), input.getY(), input.getZ());
        return this;
    }

    public LocationTag multiply(double input) {
        super.multiply(input);
        return this;
    }

    public void setWorld(World world) {
        super.setWorld(world);
        this.backupWorld = world == null ? null : world.getName();
    }

    public double distanceSquaredNoWorld(Location loc2) {
        return NumberConversions.square((double)(this.getX() - loc2.getX())) + NumberConversions.square((double)(this.getY() - loc2.getY())) + NumberConversions.square((double)(this.getZ() - loc2.getZ()));
    }

    public Inventory getBukkitInventory() {
        BlockState state = this.getBlockState();
        if (state instanceof InventoryHolder) {
            return ((InventoryHolder)state).getInventory();
        }
        return null;
    }

    public InventoryTag getInventory() {
        Inventory inv = this.getBukkitInventory();
        if (inv != null) {
            return InventoryTag.mirrorBukkitInventory(inv);
        }
        Material type = this.getBlock().getType();
        if (type == Material.ANVIL || type == Material.CHIPPED_ANVIL || type == Material.DAMAGED_ANVIL) {
            return new InventoryTag(Bukkit.createInventory(null, (InventoryType)InventoryType.ANVIL), "location", this.clone());
        }
        return null;
    }

    public BlockFace getSkullBlockFace(int rotation) {
        switch (rotation) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        return null;
    }

    public byte getSkullRotation(BlockFace face) {
        switch (face) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        return -1;
    }

    public static double[] getRotatedAroundX(double angle, double y, double z) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double newY = y * cos - z * sin;
        double newZ = y * sin + z * cos;
        return new double[]{newY, newZ};
    }

    public static double[] getRotatedAroundY(double angle, double x, double z) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double newX = x * cos + z * sin;
        double newZ = x * -sin + z * cos;
        return new double[]{newX, newZ};
    }

    public static double[] getRotatedAroundZ(double angle, double x, double y) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double newX = x * cos - y * sin;
        double newY = x * sin + y * cos;
        return new double[]{newX, newY};
    }

    public static double[] parsePointsAroundArgs(Attribute attribute) {
        if (!attribute.hasParam()) {
            return null;
        }
        MapTag inputMap = attribute.paramAsType(MapTag.class);
        if (inputMap == null) {
            return null;
        }
        ObjectTag radiusObj = inputMap.getObject("radius");
        ObjectTag pointsObj = inputMap.getObject("points");
        if (radiusObj == null || pointsObj == null) {
            return null;
        }
        ElementTag radiusElement = radiusObj.asElement();
        ElementTag amountElement = pointsObj.asElement();
        if (radiusElement == null || amountElement == null) {
            return null;
        }
        double radius = radiusElement.asDouble();
        int amount = amountElement.asInt();
        if (amount < 1) {
            attribute.echoError("Invalid amount of points! There must be at least 1 point.");
            return null;
        }
        return new double[]{radius, amount};
    }

    public int compare(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null || loc1.equals((Object)loc2)) {
            return 0;
        }
        return Double.compare(this.distanceSquared(loc1), this.distanceSquared(loc2));
    }

    public int hashCode() {
        return (int)(Math.floor(this.getX()) + Math.floor(this.getY()) + Math.floor(this.getZ()));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LocationTag)) {
            return false;
        }
        LocationTag other = (LocationTag)o;
        if (other.getWorldName() == null && this.getWorldName() != null || this.getWorldName() == null && other.getWorldName() != null || this.getWorldName() != null && other.getWorldName() != null && !CoreUtilities.equalsIgnoreCase(this.getWorldName(), other.getWorldName())) {
            return false;
        }
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ() && this.getYaw() == other.getYaw() && this.getPitch() == other.getPitch();
    }

    @Override
    public String getObjectType() {
        return "Location";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public LocationTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        String saved = LocationTag.getSaved(this);
        if (saved != null) {
            return "<Y>" + saved + "<GR> (" + this.identifyRaw().replace(",", "<G>,<GR> ") + "<GR>)";
        }
        return "<Y>" + this.identifyRaw().replace(",", "<G>,<Y> ");
    }

    @Override
    public boolean isUnique() {
        return LocationTag.getSaved(this) != null;
    }

    @Override
    public String identify() {
        String saved = LocationTag.getSaved(this);
        if (saved != null) {
            return "l@" + saved;
        }
        return this.identifyRaw();
    }

    @Override
    public String identifySimple() {
        String saved = LocationTag.getSaved(this);
        if (saved != null) {
            return saved;
        }
        if (this.getWorldName() == null) {
            return "l@" + this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ();
        }
        return "l@" + this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ() + "," + this.getWorldName();
    }

    public String identifyRaw() {
        if ((double)this.getYaw() != 0.0 || (double)this.getPitch() != 0.0) {
            return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + "," + CoreUtilities.doubleToString(this.getZ()) + "," + CoreUtilities.doubleToString(this.getPitch()) + "," + CoreUtilities.doubleToString(this.getYaw()) + (this.getWorldName() != null ? "," + this.getWorldName() : "");
        }
        return "l@" + CoreUtilities.doubleToString(this.getX()) + "," + CoreUtilities.doubleToString(this.getY()) + "," + CoreUtilities.doubleToString(this.getZ()) + (this.getWorldName() != null ? "," + this.getWorldName() : "");
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(LocationTag.class, "block_facing", (attribute, object) -> {
            BlockData block = object.getBlockDataForTag(attribute);
            MaterialTag material = new MaterialTag(block);
            if (!MaterialDirectional.describes(material)) {
                return null;
            }
            Vector vec = MaterialDirectional.getFrom(material).getDirectionVector();
            if (vec == null) {
                return null;
            }
            return new LocationTag(object.getWorld(), vec);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_facing_direction", (attribute, object) -> {
            BlockData block = object.getBlockDataForTag(attribute);
            MaterialTag material = new MaterialTag(block);
            if (!MaterialDirectional.describes(material)) {
                return null;
            }
            Vector facing = MaterialDirectional.getFrom(material).getDirectionVector();
            if (facing == null) {
                return null;
            }
            LocationTag result = object.clone();
            result.setDirection(facing);
            return result;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "above", (attribute, object) -> new LocationTag(object.clone().add(0.0, attribute.hasParam() ? attribute.getDoubleParam() : 1.0, 0.0)), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "below", (attribute, object) -> new LocationTag(object.clone().subtract(0.0, attribute.hasParam() ? attribute.getDoubleParam() : 1.0, 0.0)), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "forward_flat", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "backward_flat", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "forward", (attribute, object) -> {
            Vector vector = object.getDirection().multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "backward", (attribute, object) -> {
            Vector vector = object.getDirection().multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "left", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "right", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(0.0f);
            Vector vector = loc.getDirection().rotateAroundY(1.5707963267948966).multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "up", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(loc.getPitch() - 90.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().add(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "down", (attribute, object) -> {
            LocationTag loc = object.clone();
            loc.setPitch(loc.getPitch() - 90.0f);
            Vector vector = loc.getDirection().multiply(attribute.hasParam() ? attribute.getDoubleParam() : 1.0);
            return new LocationTag(object.clone().subtract(vector));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "relative", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag offsetLoc = attribute.paramAsType(LocationTag.class);
            if (offsetLoc == null) {
                return null;
            }
            LocationTag loc = object.clone();
            Vector offset = loc.getDirection().multiply(offsetLoc.getZ());
            loc.setPitch(loc.getPitch() - 90.0f);
            offset = offset.add(loc.getDirection().multiply(offsetLoc.getY()));
            loc.setPitch(0.0f);
            offset = offset.add(loc.getDirection().rotateAroundY(1.5707963267948966).multiply(offsetLoc.getX()));
            return new LocationTag(object.clone().add(offset));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "block", (attribute, object) -> new LocationTag(object.getWorld(), (double)object.getBlockX(), (double)object.getBlockY(), object.getBlockZ()), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "center", (attribute, object) -> new LocationTag(object.getWorld(), (double)object.getBlockX() + 0.5, (double)object.getBlockY() + 0.5, (double)object.getBlockZ() + 0.5), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "simplex_3d", (attribute, object) -> new ElementTag(SimplexNoise.noise(object.getX(), object.getY(), object.getZ())), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "random_offset", (attribute, object) -> {
            Vector offsetLimit;
            if (!attribute.hasParam()) {
                attribute.echoError("LocationTag.random_offset[...] must have an input.");
                return null;
            }
            if (ArgumentHelper.matchesDouble(attribute.getParam())) {
                double val = attribute.getDoubleParam();
                offsetLimit = new Vector(val, val, val);
            } else {
                LocationTag val = attribute.paramAsType(LocationTag.class);
                if (val == null) {
                    return null;
                }
                offsetLimit = val.toVector();
            }
            offsetLimit.setX(offsetLimit.getX() * (CoreUtilities.getRandom().nextDouble() * 2.0 - 1.0));
            offsetLimit.setY(offsetLimit.getY() * (CoreUtilities.getRandom().nextDouble() * 2.0 - 1.0));
            offsetLimit.setZ(offsetLimit.getZ() * (CoreUtilities.getRandom().nextDouble() * 2.0 - 1.0));
            LocationTag output = object.clone();
            output.add(offsetLimit);
            return output;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "highest", (attribute, object) -> {
            Location result = object.getHighestBlockForTag(attribute);
            return new LocationTag(result);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_inventory", (attribute, object) -> new ElementTag(object.getBlockStateForTag(attribute) instanceof InventoryHolder), new String[0]);
        tagProcessor.registerTag(InventoryTag.class, "inventory", (attribute, object) -> {
            if (!object.isChunkLoadedSafe()) {
                return null;
            }
            return ElementTag.handleNull(object.identify() + ".inventory", object.getInventory(), "InventoryTag", attribute.hasAlternative());
        }, new String[0]);
        tagProcessor.registerTag(MaterialTag.class, "material", (attribute, object) -> {
            BlockData block = object.getBlockDataForTag(attribute);
            if (block == null) {
                return null;
            }
            return new MaterialTag(block);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_passable", (attribute, object) -> {
            Block block = object.getBlockForTag(attribute);
            if (block == null) {
                return null;
            }
            return new ElementTag(block.isPassable());
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "patterns", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Pattern pattern : ((Banner)object.getBlockStateForTag(attribute)).getPatterns()) {
                list.add(pattern.getColor().name() + "/" + pattern.getPattern().name());
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "head_rotation", (attribute, object) -> new ElementTag(object.getSkullRotation(((Skull)object.getBlockStateForTag(attribute)).getRotation()) + 1), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "switched", (attribute, object) -> new ElementTag(SwitchCommand.switchState(object.getBlockForTag(attribute))), new String[0]);
        tagProcessor.registerTag(ListTag.class, "sign_contents", (attribute, object) -> {
            if (object.getBlockStateForTag(attribute) instanceof Sign) {
                return new ListTag(Arrays.asList(AdvancedTextImpl.instance.getSignLines((Sign)object.getBlockStateForTag(attribute))));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(EntityTag.class, "spawner_type", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new EntityTag(DenizenEntityType.getByName(((CreatureSpawner)object.getBlockStateForTag(attribute)).getSpawnedType().name()));
        }, new String[0]);
        tagProcessor.registerTag(EntityTag.class, "spawner_display_entity", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return NMSHandler.entityHelper.getMobSpawnerDisplayEntity((CreatureSpawner)object.getBlockStateForTag(attribute)).describe(attribute.context);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawner_spawn_delay", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new ElementTag(((CreatureSpawner)object.getBlockStateForTag(attribute)).getDelay());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawner_minimum_spawn_delay", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new ElementTag(((CreatureSpawner)object.getBlockStateForTag(attribute)).getMinSpawnDelay());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawner_maximum_spawn_delay", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new ElementTag(((CreatureSpawner)object.getBlockStateForTag(attribute)).getMaxSpawnDelay());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawner_player_range", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new ElementTag(((CreatureSpawner)object.getBlockStateForTag(attribute)).getRequiredPlayerRange());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawner_range", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new ElementTag(((CreatureSpawner)object.getBlockStateForTag(attribute)).getSpawnRange());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawner_max_nearby_entities", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new ElementTag(((CreatureSpawner)object.getBlockStateForTag(attribute)).getMaxNearbyEntities());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "spawner_count", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CreatureSpawner)) {
                return null;
            }
            return new ElementTag(((CreatureSpawner)object.getBlockStateForTag(attribute)).getSpawnCount());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "lock", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof Lockable)) {
                return null;
            }
            Lockable lock = (Lockable)object.getBlockStateForTag(attribute);
            return new ElementTag(lock.isLocked() ? lock.getLock() : null);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_locked", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof Lockable)) {
                return null;
            }
            return new ElementTag(((Lockable)object.getBlockStateForTag(attribute)).isLocked());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_lockable", (attribute, object) -> new ElementTag(object.getBlockStateForTag(attribute) instanceof Lockable), new String[0]);
        tagProcessor.registerTag(ListTag.class, "drops", (attribute, object) -> {
            ItemStack inputItem = null;
            if (attribute.hasParam()) {
                inputItem = attribute.paramAsType(ItemTag.class).getItemStack();
            }
            ListTag list = new ListTag();
            for (ItemStack it : object.getDropsForTag(attribute, inputItem)) {
                list.addObject(new ItemTag(it));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "xp_drop", (attribute, object) -> {
            ItemStack inputItem = new ItemStack(Material.AIR);
            if (attribute.hasParam()) {
                inputItem = attribute.paramAsType(ItemTag.class).getItemStack();
            }
            return new ElementTag(object.getExpDropForTag(attribute, inputItem));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "hive_bee_count", (attribute, object) -> new ElementTag(((Beehive)object.getBlockStateForTag(attribute)).getEntityCount()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "hive_max_bees", (attribute, object) -> new ElementTag(((Beehive)object.getBlockStateForTag(attribute)).getMaxEntities()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "skull_type", (attribute, object) -> {
            BlockState blockState = object.getBlockStateForTag(attribute);
            if (blockState instanceof Skull) {
                String t = ((Skull)blockState).getSkullType().name();
                return new ElementTag(t);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "skull_name", (attribute, object) -> {
            BlockState blockState = object.getBlockStateForTag(attribute);
            if (blockState instanceof Skull) {
                PlayerProfile profile = NMSHandler.blockHelper.getPlayerProfile((Skull)blockState);
                if (profile == null) {
                    return null;
                }
                String n = profile.getName();
                if (n == null) {
                    n = ((Skull)blockState).getOwningPlayer().getName();
                }
                return new ElementTag(n);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "skull_skin", (attribute, object) -> {
            BlockState blockState = object.getBlockStateForTag(attribute);
            if (blockState instanceof Skull) {
                PlayerProfile profile = NMSHandler.blockHelper.getPlayerProfile((Skull)blockState);
                if (profile == null) {
                    return null;
                }
                String name = profile.getName();
                UUID uuid = profile.getUniqueId();
                String texture = profile.getTexture();
                if (attribute.startsWith("full", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag((uuid != null ? uuid : name) + (texture != null ? "|" + texture : ""));
                }
                return new ElementTag(uuid != null ? uuid.toString() : name);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "round", (attribute, object) -> {
            LocationTag result = object.clone();
            result.setX(Math.round(result.getX()));
            result.setY(Math.round(result.getY()));
            result.setZ(Math.round(result.getZ()));
            result.setYaw(Math.round(result.getYaw()));
            result.setPitch(Math.round(result.getPitch()));
            return result;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "round_up", (attribute, object) -> {
            LocationTag result = object.clone();
            result.setX(Math.ceil(result.getX()));
            result.setY(Math.ceil(result.getY()));
            result.setZ(Math.ceil(result.getZ()));
            result.setYaw((float)Math.ceil(result.getYaw()));
            result.setPitch((float)Math.ceil(result.getPitch()));
            return result;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "round_down", (attribute, object) -> {
            LocationTag result = object.clone();
            result.setX(Math.floor(result.getX()));
            result.setY(Math.floor(result.getY()));
            result.setZ(Math.floor(result.getZ()));
            result.setYaw((float)Math.floor(result.getYaw()));
            result.setPitch((float)Math.floor(result.getPitch()));
            return result;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "round_to", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag LocationTag.round_to[...] must have a value.");
                return null;
            }
            LocationTag result = object.clone();
            int ten = (int)Math.pow(10.0, attribute.getIntParam());
            result.setX((double)Math.round(result.getX() * (double)ten) / (double)ten);
            result.setY((double)Math.round(result.getY() * (double)ten) / (double)ten);
            result.setZ((double)Math.round(result.getZ() * (double)ten) / (double)ten);
            result.setYaw((float)Math.round(result.getYaw() * (float)ten) / (float)ten);
            result.setPitch((float)Math.round(result.getPitch() * (float)ten) / (float)ten);
            return result;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "round_to_precision", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag LocationTag.round_to_precision[...] must have a value.");
                return null;
            }
            LocationTag result = object.clone();
            float precision = 1.0f / (float)attribute.getDoubleParam();
            result.setX((double)Math.round(result.getX() * (double)precision) / (double)precision);
            result.setY((double)Math.round(result.getY() * (double)precision) / (double)precision);
            result.setZ((double)Math.round(result.getZ() * (double)precision) / (double)precision);
            result.setYaw((float)Math.round(result.getYaw() * precision) / precision);
            result.setPitch((float)Math.round(result.getPitch() * precision) / precision);
            return result;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "simple", (attribute, object) -> {
            if (attribute.startsWith("formatted", 2)) {
                attribute.fulfill(1);
                return new ElementTag("X '" + object.getBlockX() + "', Y '" + object.getBlockY() + "', Z '" + object.getBlockZ() + "', in world '" + object.getWorldName() + "'");
            }
            if (object.getWorldName() == null) {
                return new ElementTag(object.getBlockX() + "," + object.getBlockY() + "," + object.getBlockZ());
            }
            return new ElementTag(object.getBlockX() + "," + object.getBlockY() + "," + object.getBlockZ() + "," + object.getWorldName());
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "precise_impact_normal", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object, object.getDirection(), range)) != null && traced.getHitBlockFace() != null) {
                return new LocationTag(traced.getHitBlockFace().getDirection());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "precise_cursor_on_block", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object, object.getDirection(), range)) != null && traced.getHitBlock() != null) {
                return new LocationTag(traced.getHitBlock().getLocation());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "precise_cursor_on", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object, object.getDirection(), range)) != null && traced.getHitBlock() != null) {
                return new LocationTag(traced.getHitBlock().getWorld(), traced.getHitPosition());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "precise_target_list", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            double range = attribute.getDoubleParam();
            HashSet<UUID> hitIDs = new HashSet<UUID>();
            ListTag result = new ListTag();
            Vector direction = object.getDirection();
            World world = object.getWorld();
            RayTraceResult hit;
            while ((hit = world.rayTrace((Location)object, direction, range, FluidCollisionMode.NEVER, true, 0.0, e -> !hitIDs.contains(e.getUniqueId()))) != null && hit.getHitEntity() != null) {
                hitIDs.add(hit.getHitEntity().getUniqueId());
                result.addObject(new EntityTag(hit.getHitEntity()));
            }
            return result;
        }, new String[0]);
        tagProcessor.registerTag(EntityFormObject.class, "precise_target", (attribute, object) -> {
            RayTraceResult result;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 100.0;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                HashSet<EntityType> types = new HashSet<EntityType>();
                for (String str : attribute.paramAsType(ListTag.class)) {
                    types.add(EntityTag.valueOf(str, attribute.context).getBukkitEntityType());
                }
                result = object.getWorld().rayTrace((Location)object, object.getDirection(), range, FluidCollisionMode.NEVER, true, 0.0, e -> types.contains(e.getType()));
            } else {
                result = object.getWorld().rayTrace((Location)object, object.getDirection(), range, FluidCollisionMode.NEVER, true, 0.0, null);
            }
            if (result != null && result.getHitEntity() != null) {
                return new EntityTag(result.getHitEntity()).getDenizenObject();
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "precise_target_position", (attribute, object) -> {
            RayTraceResult result;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 100.0;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                HashSet<EntityType> types = new HashSet<EntityType>();
                for (String str : attribute.paramAsType(ListTag.class)) {
                    types.add(EntityTag.valueOf(str, attribute.context).getBukkitEntityType());
                }
                result = object.getWorld().rayTrace((Location)object, object.getDirection(), range, FluidCollisionMode.NEVER, true, 0.0, e -> types.contains(e.getType()));
            } else {
                result = object.getWorld().rayTrace((Location)object, object.getDirection(), range, FluidCollisionMode.NEVER, true, 0.0, null);
            }
            if (result != null) {
                return new LocationTag(object.getWorld(), result.getHitPosition());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "points_between", (attribute, object) -> {
            LocationTag target = attribute.paramAsType(LocationTag.class);
            if (target == null) {
                return null;
            }
            double rad = 1.0;
            if (attribute.startsWith("distance", 2)) {
                rad = attribute.getDoubleContext(2);
                attribute.fulfill(1);
            }
            ListTag list = new ListTag();
            Vector rel = target.toVector().subtract(object.toVector());
            double len = rel.length();
            if (len < 1.0E-4) {
                return new ListTag();
            }
            rel = rel.multiply(1.0 / len);
            for (double i = 0.0; i <= len; i += rad) {
                list.addObject(new LocationTag(object.clone().add(rel.clone().multiply(i))));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "facing_blocks", (attribute, object) -> {
            int range = attribute.getIntParam();
            if (range < 1) {
                range = 100;
            }
            ListTag list = new ListTag();
            try {
                NMSHandler.chunkHelper.changeChunkServerThread(object.getWorld());
                BlockIterator iterator = new BlockIterator((Location)object, 0.0, range);
                while (iterator.hasNext()) {
                    list.addObject(new LocationTag(iterator.next().getLocation()));
                }
            }
            finally {
                NMSHandler.chunkHelper.restoreServerThread(object.getWorld());
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "line_of_sight", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag location = attribute.paramAsType(LocationTag.class);
            if (location != null) {
                try {
                    NMSHandler.chunkHelper.changeChunkServerThread(object.getWorld());
                    ElementTag elementTag = new ElementTag(NMSHandler.entityHelper.canTrace(object.getWorld(), object.toVector(), location.toVector()));
                    return elementTag;
                }
                finally {
                    NMSHandler.chunkHelper.restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "direction", (attribute, object) -> {
            if (attribute.startsWith("vector", 2)) {
                attribute.fulfill(1);
                return new LocationTag(object.getWorld(), object.getDirection());
            }
            if (attribute.hasParam() && LocationTag.matches(attribute.getParam())) {
                LocationTag target = attribute.paramAsType(LocationTag.class);
                if (attribute.startsWith("yaw", 2)) {
                    attribute.fulfill(1);
                    return new ElementTag(EntityHelper.normalizeYaw(NMSHandler.entityHelper.getYaw(target.toVector().subtract(object.toVector()).normalize())));
                }
                return new ElementTag(NMSHandler.entityHelper.getCardinal(NMSHandler.entityHelper.getYaw(target.toVector().subtract(object.toVector()).normalize())));
            }
            return new ElementTag(NMSHandler.entityHelper.getCardinal(object.getYaw()));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "rotate_yaw", (attribute, object) -> {
            LocationTag loc = LocationTag.valueOf(object.identify(), attribute.context).clone();
            loc.setYaw(loc.getYaw() + (float)attribute.getDoubleParam());
            return loc;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "rotate_pitch", (attribute, object) -> {
            LocationTag loc = LocationTag.valueOf(object.identify(), attribute.context).clone();
            loc.setPitch(Math.max(-90.0f, Math.min(90.0f, loc.getPitch() + (float)attribute.getDoubleParam())));
            return loc;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "face", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Location two = attribute.paramAsType(LocationTag.class);
            return new LocationTag(NMSHandler.entityHelper.faceLocation((Location)object, two));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "facing", (attribute, object) -> {
            if (attribute.hasParam()) {
                LocationTag facingLoc;
                int degrees = 45;
                if (LocationTag.matches(attribute.getParam())) {
                    facingLoc = attribute.paramAsType(LocationTag.class);
                } else if (EntityTag.matches(attribute.getParam())) {
                    facingLoc = attribute.paramAsType(EntityTag.class).getLocation();
                } else {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Tag location.facing[...] was given an invalid facing target.");
                    }
                    return null;
                }
                if (attribute.startsWith("degrees", 2) && attribute.hasContext(2)) {
                    String context = attribute.getContext(2);
                    attribute.fulfill(1);
                    if (context.contains(",")) {
                        String yaw = context.substring(0, context.indexOf(44));
                        String pitch = context.substring(context.indexOf(44) + 1);
                        degrees = Integer.parseInt(yaw);
                        int pitchDegrees = Integer.parseInt(pitch);
                        return new ElementTag(NMSHandler.entityHelper.isFacingLocation((Location)object, facingLoc, degrees, pitchDegrees));
                    }
                    degrees = Integer.parseInt(context);
                }
                return new ElementTag(NMSHandler.entityHelper.isFacingLocation((Location)object, (Location)facingLoc, (float)degrees));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "pitch", (attribute, object) -> new ElementTag(object.getPitch()), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_pose", (attribute, object) -> {
            String context = attribute.getParam();
            float pitch = 0.0f;
            float yaw = 0.0f;
            if (EntityTag.matches(context)) {
                EntityTag ent = EntityTag.valueOf(context, attribute.context);
                if (ent.isSpawnedOrValidForTag()) {
                    pitch = ent.getBukkitEntity().getLocation().getPitch();
                    yaw = ent.getBukkitEntity().getLocation().getYaw();
                }
            } else if (context.split(",").length == 2) {
                String[] split = context.split(",");
                pitch = Float.parseFloat(split[0]);
                yaw = Float.parseFloat(split[1]);
            }
            LocationTag loc = object.clone();
            loc.setPitch(pitch);
            loc.setYaw(yaw);
            return loc;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "yaw", (attribute, object) -> {
            if (attribute.startsWith("simple", 2)) {
                attribute.fulfill(1);
                float yaw = EntityHelper.normalizeYaw(object.getYaw());
                if (yaw < 45.0f) {
                    return new ElementTag("South");
                }
                if (yaw < 135.0f) {
                    return new ElementTag("West");
                }
                if (yaw < 225.0f) {
                    return new ElementTag("North");
                }
                if (yaw < 315.0f) {
                    return new ElementTag("East");
                }
                return new ElementTag("South");
            }
            if (attribute.startsWith("raw", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getYaw());
            }
            return new ElementTag(EntityHelper.normalizeYaw(object.getYaw()));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "rotate_around_x", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            double[] values = LocationTag.getRotatedAroundX(attribute.getDoubleParam(), object.getY(), object.getZ());
            LocationTag location = object.clone();
            location.setY(values[0]);
            location.setZ(values[1]);
            return new LocationTag(location);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "rotate_around_y", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            double[] values = LocationTag.getRotatedAroundY(attribute.getDoubleParam(), object.getX(), object.getZ());
            LocationTag location = object.clone();
            location.setX(values[0]);
            location.setZ(values[1]);
            return new LocationTag(location);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "rotate_around_z", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            double[] values = LocationTag.getRotatedAroundZ(attribute.getDoubleParam(), object.getX(), object.getY());
            LocationTag location = object.clone();
            location.setX(values[0]);
            location.setY(values[1]);
            return new LocationTag(location);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "points_around_x", (attribute, object) -> {
            double[] values = LocationTag.parsePointsAroundArgs(attribute);
            if (values == null) {
                return null;
            }
            double angle = Math.PI * 2 / values[1];
            ListTag points = new ListTag();
            int i = 0;
            while ((double)i < values[1]) {
                double[] result = LocationTag.getRotatedAroundX(angle * (double)i, values[0], 0.0);
                points.addObject(object.clone().add(0.0, result[0], result[1]));
                ++i;
            }
            return points;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "points_around_y", (attribute, object) -> {
            double[] values = LocationTag.parsePointsAroundArgs(attribute);
            if (values == null) {
                return null;
            }
            double angle = Math.PI * 2 / values[1];
            ListTag points = new ListTag();
            int i = 0;
            while ((double)i < values[1]) {
                double[] result = LocationTag.getRotatedAroundY(angle * (double)i, values[0], 0.0);
                points.addObject(object.clone().add(result[0], 0.0, result[1]));
                ++i;
            }
            return points;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "points_around_z", (attribute, object) -> {
            double[] values = LocationTag.parsePointsAroundArgs(attribute);
            if (values == null) {
                return null;
            }
            double angle = Math.PI * 2 / values[1];
            ListTag points = new ListTag();
            int i = 0;
            while ((double)i < values[1]) {
                double[] result = LocationTag.getRotatedAroundZ(angle * (double)i, 0.0, values[0]);
                points.addObject(object.clone().add(result[0], result[1], 0.0));
                ++i;
            }
            return points;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "flood_fill", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Adjustable area = CuboidTag.valueOf(attribute.getParam(), CoreUtilities.noDebugContext);
            if (area == null) {
                area = EllipsoidTag.valueOf(attribute.getParam(), CoreUtilities.noDebugContext);
            }
            if (area == null) {
                double radius = attribute.getDoubleParam();
                if (radius <= 0.0) {
                    return null;
                }
                area = new EllipsoidTag(object.clone(), new LocationTag(object.getWorld(), radius, radius, radius));
            }
            FloodFiller flooder = new FloodFiller();
            NMSHandler.chunkHelper.changeChunkServerThread(object.getWorld());
            try {
                if (object.getWorld() == null) {
                    attribute.echoError("LocationTag trying to read block, but cannot because no world is specified.");
                    ListTag listTag = null;
                    return listTag;
                }
                if (!object.isChunkLoaded()) {
                    attribute.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                    ListTag listTag = null;
                    return listTag;
                }
                if (attribute.startsWith("types", 2) && attribute.hasContext(2)) {
                    flooder.matcher = attribute.getContext(2);
                    attribute.fulfill(1);
                } else {
                    flooder.requiredMaterial = object.getBlock().getType();
                }
                flooder.run((LocationTag)object, (AreaContainmentObject)((Object)area));
            }
            finally {
                NMSHandler.chunkHelper.restoreServerThread(object.getWorld());
            }
            return new ListTag((Collection<? extends ObjectTag>)flooder.result);
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "find_nearest_biome", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            BiomeTag biome = attribute.paramAsType(BiomeTag.class);
            if (biome == null) {
                attribute.echoError("Invalid biome input.");
                return null;
            }
            Location result = NMSHandler.worldHelper.getNearestBiomeLocation((Location)object, biome);
            if (result == null) {
                return null;
            }
            return new LocationTag(result);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "find_blocks_flagged", (attribute, object) -> {
            if (!(attribute.hasParam() && attribute.startsWith("within", 2) && attribute.hasContext(2))) {
                attribute.echoError("find_blocks_flagged[...].within[...] tag malformed.");
                return null;
            }
            String flagName = CoreUtilities.toLowerCase(attribute.getParam());
            attribute.fulfill(1);
            double radius = attribute.getDoubleParam();
            if (!object.isChunkLoadedSafe()) {
                attribute.echoError("LocationTag trying to read block, but cannot because the chunk is unloaded. Use the 'chunkload' command to ensure the chunk is loaded.");
                return null;
            }
            double minPossibleX = object.getX() - radius;
            double minPossibleZ = object.getZ() - radius;
            double maxPossibleX = object.getX() + radius;
            double maxPossibleZ = object.getZ() + radius;
            int minChunkX = (int)Math.floor(minPossibleX / 16.0);
            int minChunkZ = (int)Math.floor(minPossibleZ / 16.0);
            int maxChunkX = (int)Math.ceil(maxPossibleX / 16.0);
            int maxChunkZ = (int)Math.ceil(maxPossibleZ / 16.0);
            ChunkTag testChunk = new ChunkTag((Location)object);
            ArrayList found = new ArrayList();
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                testChunk.chunkX = x;
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    testChunk.chunkZ = z;
                    testChunk.cachedChunk = null;
                    if (!testChunk.isLoadedSafe()) continue;
                    LocationFlagSearchHelper.getFlaggedLocations(testChunk.getChunkForTag(attribute), flagName, loc -> {
                        loc.setX(loc.getX() + 0.5);
                        loc.setY(loc.getY() + 0.5);
                        loc.setZ(loc.getZ() + 0.5);
                        if (Utilities.checkLocation(object, loc, radius)) {
                            found.add(new LocationTag((Location)loc));
                        }
                    });
                }
            }
            found.sort(object::compare);
            return new ListTag(found);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "find_entities", (attribute, object) -> {
            String matcher;
            String string = matcher = attribute.hasParam() ? attribute.getParam() : null;
            if (!attribute.startsWith("within", 2) || !attribute.hasContext(2)) {
                return null;
            }
            double radius = attribute.getDoubleContext(2);
            attribute.fulfill(1);
            ListTag found = new ListTag();
            BoundingBox box = BoundingBox.of((Location)object, (double)radius, (double)radius, (double)radius);
            for (Entity entity : new WorldTag(object.getWorld()).getPossibleEntitiesForBoundaryForTag(box)) {
                if (!Utilities.checkLocationWithBoundingBox(object, entity, radius)) continue;
                EntityTag current = new EntityTag(entity);
                if (matcher != null && !current.tryAdvancedMatcher(matcher)) continue;
                found.addObject(current.getDenizenObject());
            }
            found.objectForms.sort((ent1, ent2) -> object.compare(((EntityFormObject)ent1).getLocation(), ((EntityFormObject)ent2).getLocation()));
            return found;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "find_blocks", (attribute, object) -> {
            String matcher;
            String string = matcher = attribute.hasParam() ? attribute.getParam() : null;
            if (!attribute.startsWith("within", 2) || !attribute.hasContext(2)) {
                return null;
            }
            double radius = attribute.getDoubleContext(2);
            attribute.fulfill(1);
            ListTag found = new ListTag();
            int max = Settings.blockTagsMaxBlocks();
            int index = 0;
            LocationTag tstart = object.getBlockLocation();
            double tstartY = tstart.getY();
            int radiusInt = (int)Math.ceil(radius);
            block0: for (int y = -radiusInt; y <= radiusInt; ++y) {
                double newY = (double)y + tstartY;
                if (!Utilities.isLocationYSafe(newY, object.getWorld())) continue;
                for (int x = -radiusInt; x <= radiusInt; ++x) {
                    for (int z = -radiusInt; z <= radiusInt; ++z) {
                        if (++index > max) break block0;
                        if (!Utilities.checkLocation(object, tstart.clone().add((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), radius) || matcher != null && !new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).tryAdvancedMatcher(matcher)) continue;
                        found.addObject(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                    }
                }
            }
            found.objectForms.sort((loc1, loc2) -> object.compare((LocationTag)loc1, (LocationTag)loc2));
            return found;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "find_spawnable_blocks_within", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            double radius = attribute.getDoubleParam();
            ListTag found = new ListTag();
            int max = Settings.blockTagsMaxBlocks();
            int index = 0;
            LocationTag tstart = object.getBlockLocation();
            double tstartY = tstart.getY();
            int radiusInt = (int)Math.ceil(radius);
            block0: for (int y = -radiusInt; y <= radiusInt; ++y) {
                double newY = (double)y + tstartY;
                if (!Utilities.isLocationYSafe(newY, object.getWorld())) continue;
                for (int x = -radiusInt; x <= radiusInt; ++x) {
                    for (int z = -radiusInt; z <= radiusInt; ++z) {
                        if (++index > max) break block0;
                        Location loc = tstart.clone().add((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                        if (!Utilities.checkLocation(object, loc, radius) || !SpawnableHelper.isSpawnable(loc)) continue;
                        found.addObject(new LocationTag(loc.add(0.0, -0.5, 0.0)));
                    }
                }
            }
            found.objectForms.sort((loc1, loc2) -> object.compare((LocationTag)loc1, (LocationTag)loc2));
            return found;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "find_players_within", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            double radius = attribute.getDoubleParam();
            ArrayList<PlayerTag> found = new ArrayList<PlayerTag>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.isDead() || !Utilities.checkLocationWithBoundingBox(object, (Entity)player, radius)) continue;
                found.add(new PlayerTag(player));
            }
            found.sort((pl1, pl2) -> object.compare(pl1.getLocation(), pl2.getLocation()));
            return new ListTag((Collection<? extends ObjectTag>)found);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "find_npcs_within", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            double radius = attribute.getDoubleParam();
            ArrayList<NPCTag> found = new ArrayList<NPCTag>();
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.isSpawned() || !Utilities.checkLocationWithBoundingBox(object, npc.getEntity(), radius)) continue;
                found.add(new NPCTag(npc));
            }
            found.sort((npc1, npc2) -> object.compare(npc1.getLocation(), npc2.getLocation()));
            return new ListTag((Collection<? extends ObjectTag>)found);
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "find", (attribute, object) -> {
            if (!attribute.startsWith("within", 3) || !attribute.hasContext(3)) {
                return null;
            }
            double radius = attribute.getDoubleContext(3);
            if (attribute.startsWith("blocks", 2)) {
                BukkitImplDeprecations.locationFindEntities.warn(attribute.context);
                ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(2)) {
                    materials = attribute.contextAsType(2, ListTag.class).filter(MaterialTag.class, attribute.context);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                LocationTag tstart = object.getBlockLocation();
                double tstartY = tstart.getY();
                int radiusInt = (int)radius;
                block0: for (int x = -radiusInt; x <= radiusInt; ++x) {
                    for (int y = -radiusInt; y <= radiusInt; ++y) {
                        double newY = (double)y + tstartY;
                        if (!Utilities.isLocationYSafe(newY, object.getWorld())) continue;
                        for (int z = -radiusInt; z <= radiusInt; ++z) {
                            if (++index > max) break block0;
                            if (!Utilities.checkLocation(object, tstart.clone().add((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), radius)) continue;
                            if (!materials.isEmpty()) {
                                for (MaterialTag materialTag : materials) {
                                    if (materialTag.getMaterial() != new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)).getBlockTypeForTag(attribute)) continue;
                                    found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                                }
                                continue;
                            }
                            found.add(new LocationTag(tstart.clone().add((double)x, (double)y, (double)z)));
                        }
                    }
                }
                found.sort(object::compare);
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("surface_blocks", 2)) {
                ArrayList<LocationTag> found = new ArrayList<LocationTag>();
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(2)) {
                    materials = attribute.contextAsType(2, ListTag.class).filter(MaterialTag.class, attribute.context);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                LocationTag blockLoc = object.getBlockLocation();
                Location loc = blockLoc.clone().add(0.5, 0.5, 0.5);
                block4: for (double x = -radius; x <= radius; x += 1.0) {
                    for (double y = -radius; y <= radius; y += 1.0) {
                        for (double z = -radius; z <= radius; z += 1.0) {
                            if (++index > max) break block4;
                            if (!Utilities.checkLocation(loc, blockLoc.clone().add(x + 0.5, y + 0.5, z + 0.5), radius)) continue;
                            LocationTag l = new LocationTag(blockLoc.clone().add(x, y, z));
                            if (!materials.isEmpty()) {
                                for (MaterialTag materialTag : materials) {
                                    if (materialTag.getMaterial() != l.getBlockTypeForTag(attribute) || new LocationTag(l.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(l.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || l.getBlockTypeForTag(attribute) == Material.AIR) continue;
                                    found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                                }
                                continue;
                            }
                            if (new LocationTag(l.clone().add(0.0, 1.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || new LocationTag(l.clone().add(0.0, 2.0, 0.0)).getBlockTypeForTag(attribute) != Material.AIR || l.getBlockTypeForTag(attribute) == Material.AIR) continue;
                            found.add(new LocationTag(blockLoc.clone().add(x + 0.5, y, z + 0.5)));
                        }
                    }
                }
                found.sort(object::compare);
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("players", 2)) {
                BukkitImplDeprecations.locationFindEntities.warn(attribute.context);
                ArrayList<PlayerTag> found = new ArrayList<PlayerTag>();
                attribute.fulfill(2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.isDead() || !Utilities.checkLocationWithBoundingBox(object, (Entity)player, radius)) continue;
                    found.add(new PlayerTag(player));
                }
                found.sort((pl1, pl2) -> object.compare(pl1.getLocation(), pl2.getLocation()));
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("npcs", 2)) {
                BukkitImplDeprecations.locationFindEntities.warn(attribute.context);
                ArrayList<NPCTag> found = new ArrayList<NPCTag>();
                attribute.fulfill(2);
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    if (!npc.isSpawned() || !Utilities.checkLocationWithBoundingBox(object, npc.getEntity(), radius)) continue;
                    found.add(new NPCTag(npc));
                }
                found.sort((npc1, npc2) -> object.compare(npc1.getLocation(), npc2.getLocation()));
                return new ListTag((Collection<? extends ObjectTag>)found);
            }
            if (attribute.startsWith("entities", 2)) {
                BukkitImplDeprecations.locationFindEntities.warn(attribute.context);
                ListTag ent_list = attribute.hasContext(2) ? attribute.contextAsType(2, ListTag.class) : null;
                ListTag found = new ListTag();
                attribute.fulfill(2);
                block10: for (Entity entity : new WorldTag(object.getWorld()).getEntitiesForTag()) {
                    if (!Utilities.checkLocationWithBoundingBox(object, entity, radius)) continue;
                    EntityTag current = new EntityTag(entity);
                    if (ent_list != null) {
                        for (String ent : ent_list) {
                            if (!current.comparedTo(ent)) continue;
                            found.addObject(current.getDenizenObject());
                            continue block10;
                        }
                        continue;
                    }
                    found.addObject(current.getDenizenObject());
                }
                found.objectForms.sort((ent1, ent2) -> object.compare(((EntityFormObject)ent1).getLocation(), ((EntityFormObject)ent2).getLocation()));
                return new ListTag((Collection<? extends ObjectTag>)found.objectForms);
            }
            if (attribute.startsWith("living_entities", 2)) {
                ListTag found = new ListTag();
                attribute.fulfill(2);
                BoundingBox box = BoundingBox.of((Location)object, (double)radius, (double)radius, (double)radius);
                for (Entity entity : new WorldTag(object.getWorld()).getPossibleEntitiesForBoundaryForTag(box)) {
                    if (!(entity instanceof LivingEntity) || !Utilities.checkLocationWithBoundingBox(object, entity, radius)) continue;
                    found.addObject(new EntityTag(entity).getDenizenObject());
                }
                found.objectForms.sort((ent1, ent2) -> object.compare(((EntityFormObject)ent1).getLocation(), ((EntityFormObject)ent2).getLocation()));
                return new ListTag((Collection<? extends ObjectTag>)found.objectForms);
            }
            if (attribute.startsWith("structure", 2) && attribute.hasContext(2)) {
                String typeName = attribute.getContext(2);
                StructureType type = (StructureType)StructureType.getStructureTypes().get(typeName);
                if (type == null) {
                    attribute.echoError("Invalid structure type '" + typeName + "'.");
                    return null;
                }
                attribute.fulfill(2);
                Location result = object.getWorld().locateNearestStructure((Location)object, type, (int)radius, false);
                if (result == null) {
                    return null;
                }
                return new LocationTag(result);
            }
            if (attribute.startsWith("unexplored_structure", 2) && attribute.hasContext(2)) {
                String typeName = attribute.getContext(2);
                StructureType type = (StructureType)StructureType.getStructureTypes().get(typeName);
                if (type == null) {
                    attribute.echoError("Invalid structure type '" + typeName + "'.");
                    return null;
                }
                attribute.fulfill(2);
                Location result = object.getWorld().locateNearestStructure((Location)object, type, (int)radius, true);
                if (result == null) {
                    return null;
                }
                return new LocationTag(result);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "find_path", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag two = attribute.paramAsType(LocationTag.class);
            if (two == null) {
                return null;
            }
            List<LocationTag> locs = PathFinder.getPath(object, two);
            ListTag list = new ListTag();
            for (LocationTag loc : locs) {
                list.addObject(loc);
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "formatted", (attribute, object) -> {
            if (attribute.startsWith("citizens", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getX() + ":" + object.getY() + ":" + object.getZ() + ":" + object.getWorldName());
            }
            return new ElementTag("X '" + object.getX() + "', Y '" + object.getY() + "', Z '" + object.getZ() + "', in world '" + object.getWorldName() + "'");
        }, new String[0]);
        tagProcessor.registerTag(ChunkTag.class, "chunk", (attribute, object) -> new ChunkTag((Location)object), "get_chunk");
        tagProcessor.registerTag(ElementTag.class, "raw", (attribute, object) -> new ElementTag(object.identifyRaw()), new String[0]);
        tagProcessor.registerTag(WorldTag.class, "world", (attribute, object) -> WorldTag.mirrorBukkitWorld(object.getWorld()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "x", (attribute, object) -> new ElementTag(object.getX()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "y", (attribute, object) -> new ElementTag(object.getY()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "z", (attribute, object) -> new ElementTag(object.getZ()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "xyz", (attribute, object) -> new ElementTag(CoreUtilities.doubleToString(object.getX()) + "," + CoreUtilities.doubleToString(object.getY()) + "," + CoreUtilities.doubleToString(object.getZ())), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_x", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag output = object.clone();
            output.setX(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_y", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag output = object.clone();
            output.setY(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_z", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag output = object.clone();
            output.setZ(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_yaw", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag output = object.clone();
            output.setYaw((float)attribute.getDoubleParam());
            return output;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_pitch", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag output = object.clone();
            output.setPitch((float)attribute.getDoubleParam());
            return output;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "with_world", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            LocationTag output = object.clone();
            WorldTag world = attribute.paramAsType(WorldTag.class);
            output.setWorld(world.getWorld());
            return output;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "note_name", (attribute, object) -> {
            String noteName = NoteManager.getSavedId(object);
            if (noteName == null) {
                return null;
            }
            return new ElementTag(noteName);
        }, "notable_name");
        tagProcessor.registerTag(LocationTag.class, "add", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String[] ints = attribute.getParam().replace("l@", "").split(",", 4);
            if (ints.length >= 3 && ArgumentHelper.matchesDouble(ints[0]) && ArgumentHelper.matchesDouble(ints[1]) && ArgumentHelper.matchesDouble(ints[2])) {
                return new LocationTag(object.clone().add(Double.parseDouble(ints[0]), Double.parseDouble(ints[1]), Double.parseDouble(ints[2])));
            }
            if (LocationTag.matches(attribute.getParam())) {
                return object.clone().add(attribute.paramAsType(LocationTag.class));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "sub", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String[] ints = attribute.getParam().replace("l@", "").split(",", 4);
            if ((ints.length == 3 || ints.length == 4) && ArgumentHelper.matchesDouble(ints[0]) && ArgumentHelper.matchesDouble(ints[1]) && ArgumentHelper.matchesDouble(ints[2])) {
                return new LocationTag(object.clone().subtract(Double.parseDouble(ints[0]), Double.parseDouble(ints[1]), Double.parseDouble(ints[2])));
            }
            if (LocationTag.matches(attribute.getParam())) {
                return new LocationTag(object.clone().subtract(attribute.paramAsType(LocationTag.class)));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "mul", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new LocationTag(object.clone().multiply(Double.parseDouble(attribute.getParam())));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "div", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new LocationTag(object.clone().multiply(1.0 / Double.parseDouble(attribute.getParam())));
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "normalize", (attribute, object) -> {
            double len = Math.sqrt(Math.pow(object.getX(), 2.0) + Math.pow(object.getY(), 2.0) + Math.pow(object.getZ(), 2.0));
            if (len == 0.0) {
                len = 1.0;
            }
            return new LocationTag(object.clone().multiply(1.0 / len));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "vector_length", (attribute, object) -> new ElementTag(Math.sqrt(Math.pow(object.getX(), 2.0) + Math.pow(object.getY(), 2.0) + Math.pow(object.getZ(), 2.0))), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "vector_to_face", (attribute, object) -> {
            BlockFace face = Utilities.faceFor(object.toVector());
            if (face != null) {
                return new ElementTag(face.name());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "distance_squared", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            if (LocationTag.matches(attribute.getParam())) {
                LocationTag toLocation = attribute.paramAsType(LocationTag.class);
                if (object.getWorldName() == null) {
                    return new ElementTag(object.toVector().distanceSquared(toLocation.toVector()));
                }
                if (!object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Can't measure distance between two different worlds!");
                    }
                    return null;
                }
                return new ElementTag(object.distanceSquared(toLocation));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "distance", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            if (LocationTag.matches(attribute.getParam())) {
                LocationTag toLocation = attribute.paramAsType(LocationTag.class);
                if (attribute.startsWith("horizontal", 2)) {
                    if (attribute.startsWith("multiworld", 3)) {
                        attribute.fulfill(2);
                        return new ElementTag(Math.sqrt(Math.pow(object.getX() - toLocation.getX(), 2.0) + Math.pow(object.getZ() - toLocation.getZ(), 2.0)));
                    }
                    attribute.fulfill(1);
                    if (object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                        return new ElementTag(Math.sqrt(Math.pow(object.getX() - toLocation.getX(), 2.0) + Math.pow(object.getZ() - toLocation.getZ(), 2.0)));
                    }
                } else if (attribute.startsWith("vertical", 2)) {
                    if (attribute.startsWith("multiworld", 3)) {
                        attribute.fulfill(2);
                        return new ElementTag(Math.abs(object.getY() - toLocation.getY()));
                    }
                    attribute.fulfill(1);
                    if (object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                        return new ElementTag(Math.abs(object.getY() - toLocation.getY()));
                    }
                }
                if (object.getWorldName() == null) {
                    return new ElementTag(object.toVector().distance(toLocation.toVector()));
                }
                if (!object.getWorldName().equalsIgnoreCase(toLocation.getWorldName())) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Can't measure distance between two different worlds!");
                    }
                    return null;
                }
                return new ElementTag(object.distance(toLocation));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_within_border", (attribute, object) -> new ElementTag(object.getWorld().getWorldBorder().isInside((Location)object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_within", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            if (EllipsoidTag.matches(attribute.getParam())) {
                EllipsoidTag ellipsoid = attribute.paramAsType(EllipsoidTag.class);
                if (ellipsoid != null) {
                    return new ElementTag(ellipsoid.contains((Location)object));
                }
            } else if (PolygonTag.matches(attribute.getParam())) {
                PolygonTag polygon = attribute.paramAsType(PolygonTag.class);
                if (polygon != null) {
                    return new ElementTag(polygon.doesContainLocation((Location)object));
                }
            } else {
                CuboidTag cuboid = attribute.paramAsType(CuboidTag.class);
                if (cuboid != null) {
                    return new ElementTag(cuboid.isInsideCuboid((Location)object));
                }
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(EllipsoidTag.class, "to_ellipsoid", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("to_ellipsoid[...] tag must have input.");
                return null;
            }
            return new EllipsoidTag(object.clone(), attribute.getParamObject().asType(LocationTag.class, attribute.context));
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "to_cuboid", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("to_cuboid[...] tag must have input.");
                return null;
            }
            return new CuboidTag(object.clone(), attribute.getParamObject().asType(LocationTag.class, attribute.context));
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "biome", (attribute, object) -> {
            if (attribute.startsWith("formatted", 2)) {
                BukkitImplDeprecations.locationBiomeFormattedTag.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(CoreUtilities.toLowerCase(object.getBiomeForTag(attribute).getName()).replace('_', ' '));
            }
            return new BiomeTag(object.getBiomeForTag(attribute));
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "areas", (attribute, object) -> {
            ListTag list = new ListTag();
            NotedAreaTracker.forEachAreaThatContains(object, area -> list.addObject((ObjectTag)area));
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "cuboids", (attribute, object) -> {
            ListTag list = new ListTag();
            NotedAreaTracker.forEachAreaThatContains(object, area -> {
                if (area instanceof CuboidTag) {
                    list.addObject((ObjectTag)area);
                }
            });
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "ellipsoids", (attribute, object) -> {
            ListTag list = new ListTag();
            NotedAreaTracker.forEachAreaThatContains(object, area -> {
                if (area instanceof EllipsoidTag) {
                    list.addObject((ObjectTag)area);
                }
            });
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "polygons", (attribute, object) -> {
            ListTag list = new ListTag();
            NotedAreaTracker.forEachAreaThatContains(object, area -> {
                if (area instanceof PolygonTag) {
                    list.addObject((ObjectTag)area);
                }
            });
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_liquid", (attribute, object) -> {
            Block b = object.getBlockForTag(attribute);
            if (b != null) {
                try {
                    NMSHandler.chunkHelper.changeChunkServerThread(object.getWorld());
                    ElementTag elementTag = new ElementTag(b.isLiquid());
                    return elementTag;
                }
                finally {
                    NMSHandler.chunkHelper.restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "light", (attribute, object) -> {
            Block b = object.getBlockForTag(attribute);
            if (b != null) {
                try {
                    NMSHandler.chunkHelper.changeChunkServerThread(object.getWorld());
                    if (attribute.startsWith("blocks", 2)) {
                        attribute.fulfill(1);
                        ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightFromBlocks());
                        return elementTag;
                    }
                    if (attribute.startsWith("sky", 2)) {
                        attribute.fulfill(1);
                        ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightFromSky());
                        return elementTag;
                    }
                    ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getLightLevel());
                    return elementTag;
                }
                finally {
                    NMSHandler.chunkHelper.restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "power", (attribute, object) -> {
            Block b = object.getBlockForTag(attribute);
            if (b != null) {
                try {
                    NMSHandler.chunkHelper.changeChunkServerThread(object.getWorld());
                    ElementTag elementTag = new ElementTag(object.getBlockForTag(attribute).getBlockPower());
                    return elementTag;
                }
                finally {
                    NMSHandler.chunkHelper.restoreServerThread(object.getWorld());
                }
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "lectern_page", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (state instanceof Lectern) {
                return new ElementTag(((Lectern)state).getPage());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_loot_table", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (state instanceof Lootable) {
                return new ElementTag(((Lootable)state).getLootTable() != null);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "loot_table_id", (attribute, object) -> {
            LootTable table;
            BlockState state = object.getBlockStateForTag(attribute);
            if (state instanceof Lootable && (table = ((Lootable)state).getLootTable()) != null) {
                return new ElementTag(table.getKey().toString());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "tree_distance", (attribute, object) -> {
            BukkitImplDeprecations.locationDistanceTag.warn(attribute.context);
            MaterialTag material = new MaterialTag(object.getBlockDataForTag(attribute));
            if (MaterialDistance.describes(material)) {
                return new ElementTag(MaterialDistance.getFrom(material).getDistance());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "command_block_name", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CommandBlock)) {
                return null;
            }
            return new ElementTag(((CommandBlock)object.getBlockStateForTag(attribute)).getName());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "command_block", (attribute, object) -> {
            if (!(object.getBlockStateForTag(attribute) instanceof CommandBlock)) {
                return null;
            }
            return new ElementTag(((CommandBlock)object.getBlockStateForTag(attribute)).getCommand());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "brewing_time", (attribute, object) -> new DurationTag((long)((BrewingStand)object.getBlockStateForTag(attribute)).getBrewingTime()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "brewing_fuel_level", (attribute, object) -> new ElementTag(((BrewingStand)object.getBlockStateForTag(attribute)).getFuelLevel()), new String[0]);
        tagProcessor.registerTag(DurationTag.class, "furnace_burn_duration", (attribute, object) -> new DurationTag((long)((Furnace)object.getBlockStateForTag(attribute)).getBurnTime()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "furnace_burn_time", (attribute, object) -> {
            BukkitImplDeprecations.furnaceTimeTags.warn(attribute.context);
            return new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getBurnTime());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "furnace_cook_duration", (attribute, object) -> new DurationTag((long)((Furnace)object.getBlockStateForTag(attribute)).getCookTime()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "furnace_cook_time", (attribute, object) -> {
            BukkitImplDeprecations.furnaceTimeTags.warn(attribute.context);
            return new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getCookTime());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "furnace_cook_duration_total", (attribute, object) -> new DurationTag((long)((Furnace)object.getBlockStateForTag(attribute)).getCookTimeTotal()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "furnace_cook_time_total", (attribute, object) -> {
            BukkitImplDeprecations.furnaceTimeTags.warn(attribute.context);
            return new ElementTag(((Furnace)object.getBlockStateForTag(attribute)).getCookTimeTotal());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "beacon_tier", (attribute, object) -> new ElementTag(((Beacon)object.getBlockStateForTag(attribute)).getTier()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "beacon_primary_effect", (attribute, object) -> {
            PotionEffect effect = ((Beacon)object.getBlockStateForTag(attribute)).getPrimaryEffect();
            if (effect == null) {
                return null;
            }
            return new ElementTag(effect.getType().getName());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "beacon_secondary_effect", (attribute, object) -> {
            PotionEffect effect = ((Beacon)object.getBlockStateForTag(attribute)).getSecondaryEffect();
            if (effect == null) {
                return null;
            }
            return new ElementTag(effect.getType().getName());
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "attached_to", (attribute, object) -> {
            BlockFace face = BlockFace.SELF;
            MaterialTag material = new MaterialTag(object.getBlockDataForTag(attribute));
            if (material.getMaterial() == Material.TORCH || material.getMaterial() == Material.REDSTONE_TORCH || material.getMaterial() == Material.SOUL_TORCH) {
                face = BlockFace.DOWN;
            } else if (material.getMaterial() == Material.WALL_TORCH || material.getMaterial() == Material.REDSTONE_WALL_TORCH || material.getMaterial() == Material.SOUL_WALL_TORCH) {
                face = ((Directional)material.getModernData()).getFacing().getOppositeFace();
            } else if (MaterialSwitchFace.describes(material)) {
                face = MaterialSwitchFace.getFrom(material).getAttachedTo();
            } else if (material.hasModernData() && material.getModernData() instanceof WallSign) {
                face = ((WallSign)material.getModernData()).getFacing().getOppositeFace();
            } else {
                MaterialData data = object.getBlockStateForTag(attribute).getData();
                if (data instanceof Attachable) {
                    face = ((Attachable)data).getAttachedFace();
                }
            }
            if (face != BlockFace.SELF) {
                return new LocationTag(object.getBlockForTag(attribute).getRelative(face).getLocation());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "other_block", (attribute, object) -> {
            Vector vec;
            BlockData b = object.getBlockDataForTag(attribute);
            MaterialTag material = new MaterialTag(b);
            if (MaterialHalf.describes(material) && (vec = MaterialHalf.getFrom(material).getRelativeBlockVector()) != null) {
                return new LocationTag(object.clone().add(vec));
            }
            if (!attribute.hasAlternative()) {
                Debug.echoError("Block of type " + object.getBlockTypeForTag(attribute).name() + " isn't supported by other_block.");
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "custom_name", (attribute, object) -> {
            if (object.getBlockStateForTag(attribute) instanceof Nameable) {
                return new ElementTag(AdvancedTextImpl.instance.getCustomName((Nameable)object.getBlockStateForTag(attribute)));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "local_difficulty", (attribute, object) -> new ElementTag(NMSHandler.worldHelper.getLocalDifficulty((Location)object)), new String[0]);
        tagProcessor.registerTag(ItemTag.class, "jukebox_record", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof Jukebox)) {
                attribute.echoError("'jukebox_record' tag is only valid for jukebox blocks.");
                return null;
            }
            return new ItemTag(((Jukebox)state).getRecord());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "jukebox_is_playing", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof Jukebox)) {
                attribute.echoError("'jukebox_is_playing' tag is only valid for jukebox blocks.");
                return null;
            }
            return new ElementTag(((Jukebox)state).isPlaying());
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "age", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof EndGateway)) {
                attribute.echoError("'age' tag is only valid for end_gateway blocks.");
                return null;
            }
            return new DurationTag(((EndGateway)state).getAge());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_exact_teleport", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof EndGateway)) {
                attribute.echoError("'is_exact_teleport' tag is only valid for end_gateway blocks.");
                return null;
            }
            return new ElementTag(((EndGateway)state).isExactTeleport());
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "exit_location", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof EndGateway)) {
                attribute.echoError("'exit_location' tag is only valid for end_gateway blocks.");
                return null;
            }
            Location loc = ((EndGateway)state).getExitLocation();
            if (loc == null) {
                return null;
            }
            return new LocationTag(loc);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_in", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(BukkitScriptEvent.inCheckInternal(attribute.context, "is_in tag", object, attribute.getParam(), "is_in tag", "is_in tag"));
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "campfire_items", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof Campfire)) {
                return null;
            }
            Campfire fire = (Campfire)state;
            ListTag output = new ListTag();
            for (int i = 0; i < fire.getSize(); ++i) {
                output.addObject(new ItemTag(fire.getItem(i)));
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_spawnable", (attribute, object) -> new ElementTag(SpawnableHelper.isSpawnable(object)), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "sign_glowing", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof Sign)) {
                attribute.echoError("Location is not a valid Sign block.");
                return null;
            }
            return new ElementTag(((Sign)state).isGlowingText());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "sign_glow_color", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof Sign)) {
                attribute.echoError("Location is not a valid Sign block.");
                return null;
            }
            return new ElementTag(((Sign)state).getColor().name());
        }, new String[0]);
        tagProcessor.registerTag(ColorTag.class, "map_color", (attribute, object) -> {
            Block block = object.getBlockForTag(attribute);
            if (block == null) {
                return null;
            }
            return new ColorTag(NMSHandler.blockHelper.getMapColor(block));
        }, new String[0]);
        tagProcessor.registerTag(MapTag.class, "structure_block_data", (attribute, object) -> {
            BlockState state = object.getBlockStateForTag(attribute);
            if (!(state instanceof Structure)) {
                attribute.echoError("Location is not a valid Structure block.");
                return null;
            }
            Structure structure = (Structure)state;
            MapTag output = new MapTag();
            output.putObject("author", new ElementTag(structure.getAuthor()));
            output.putObject("integrity", new ElementTag(structure.getIntegrity()));
            output.putObject("metadata", new ElementTag(structure.getMetadata()));
            output.putObject("mirror", new ElementTag(structure.getMirror().name()));
            output.putObject("box_position", new LocationTag((Vector)structure.getRelativePosition()));
            output.putObject("rotation", new ElementTag(structure.getRotation().name()));
            output.putObject("seed", new ElementTag(structure.getSeed()));
            output.putObject("structure_name", new ElementTag(structure.getStructureName()));
            output.putObject("size", new LocationTag((Vector)structure.getStructureSize()));
            output.putObject("mode", new ElementTag(structure.getUsageMode().name()));
            output.putObject("box_visible", new ElementTag(structure.isBoundingBoxVisible()));
            output.putObject("ignore_entities", new ElementTag(structure.isIgnoreEntities()));
            output.putObject("show_invisible", new ElementTag(structure.isShowAir()));
            return output;
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a location!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Sign sign;
        boolean generated;
        Furnace furnace;
        BrewingStand stand;
        CommandBlock block;
        Beehive hive;
        ListTag list;
        BlockState state;
        CreatureSpawner spawner;
        AbstractFlagTracker.tryFlagAdjusts(this, mechanism);
        if (mechanism.matches("block_facing") && mechanism.requireObject(LocationTag.class)) {
            LocationTag faceVec = mechanism.valueAsType(LocationTag.class);
            Block block2 = this.getBlock();
            MaterialTag material = new MaterialTag(block2);
            if (!MaterialDirectional.describes(material)) {
                mechanism.echoError("LocationTag.block_facing mechanism failed: block is not directional.");
                return;
            }
            MaterialDirectional.getFrom(material).setFacing(Utilities.faceFor(faceVec.toVector()));
            block2.setBlockData(material.getModernData());
        }
        if (mechanism.matches("block_type") && mechanism.requireObject(MaterialTag.class)) {
            MaterialTag mat = mechanism.valueAsType(MaterialTag.class);
            this.getBlock().setBlockData(mat.getModernData(), false);
        }
        if (mechanism.matches("biome") && mechanism.requireObject(BiomeTag.class)) {
            mechanism.valueAsType(BiomeTag.class).getBiome().setTo(this.getBlock());
        }
        if (mechanism.matches("spawner_custom_rules") && mechanism.requireObject(MapTag.class) && this.getBlockState() instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)this.getBlockState();
            MapTag map = mechanism.valueAsType(MapTag.class);
            ObjectTag skyMin = map.getObject("sky_min");
            ObjectTag skyMax = map.getObject("sky_max");
            ObjectTag blockMin = map.getObject("block_min");
            ObjectTag blockMax = map.getObject("block_max");
            if (skyMin == null || skyMax == null || blockMin == null || blockMax == null) {
                mechanism.echoError("Invalid spawner_custom_rules input, missing map keys.");
                return;
            }
            NMSHandler.blockHelper.setSpawnerCustomRules(spawner, Integer.parseInt(skyMin.toString()), Integer.parseInt(skyMax.toString()), Integer.parseInt(blockMin.toString()), Integer.parseInt(blockMax.toString()));
            spawner.update();
        }
        if (mechanism.matches("spawner_type") && mechanism.requireObject(EntityTag.class) && this.getBlockState() instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)this.getBlockState();
            NMSHandler.blockHelper.setSpawnerSpawnedType(spawner, mechanism.valueAsType(EntityTag.class));
            spawner.update();
        }
        if (mechanism.matches("spawner_delay_data") && this.getBlockState() instanceof CreatureSpawner) {
            ListTag list2 = mechanism.valueAsType(ListTag.class);
            if (list2.size() < 3) {
                return;
            }
            CreatureSpawner spawner2 = (CreatureSpawner)this.getBlockState();
            spawner2.setDelay(Integer.parseInt(list2.get(0)));
            int minDelay = Integer.parseInt(list2.get(1));
            int maxDelay = Integer.parseInt(list2.get(2));
            if (minDelay > spawner2.getMaxSpawnDelay()) {
                spawner2.setMaxSpawnDelay(maxDelay);
                spawner2.setMinSpawnDelay(minDelay);
            } else {
                spawner2.setMinSpawnDelay(minDelay);
                spawner2.setMaxSpawnDelay(maxDelay);
            }
            spawner2.update();
        }
        if (mechanism.matches("spawner_max_nearby_entities") && mechanism.requireInteger() && this.getBlockState() instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)this.getBlockState();
            spawner.setMaxNearbyEntities(mechanism.getValue().asInt());
            spawner.update();
        }
        if (mechanism.matches("spawner_player_range") && mechanism.requireInteger() && this.getBlockState() instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)this.getBlockState();
            spawner.setRequiredPlayerRange(mechanism.getValue().asInt());
            spawner.update();
        }
        if (mechanism.matches("spawner_range") && mechanism.requireInteger() && this.getBlockState() instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)this.getBlockState();
            spawner.setSpawnRange(mechanism.getValue().asInt());
            spawner.update();
        }
        if (mechanism.matches("spawner_count") && mechanism.requireInteger() && this.getBlockState() instanceof CreatureSpawner) {
            spawner = (CreatureSpawner)this.getBlockState();
            spawner.setSpawnCount(mechanism.getValue().asInt());
            spawner.update();
        }
        if (mechanism.matches("lock") && this.getBlockState() instanceof Lockable) {
            state = this.getBlockState();
            ((Lockable)state).setLock(mechanism.hasValue() ? mechanism.getValue().asString() : null);
            state.update();
        }
        if (mechanism.matches("sign_contents") && this.getBlockState() instanceof Sign) {
            state = (Sign)this.getBlockState();
            for (int i = 0; i < 4; ++i) {
                AdvancedTextImpl.instance.setSignLine((Sign)state, i, "");
            }
            list = mechanism.valueAsType(ListTag.class);
            CoreUtilities.fixNewLinesToListSeparation(list);
            if (list.size() > 4) {
                Debug.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    AdvancedTextImpl.instance.setSignLine((Sign)state, i, list.get(i));
                }
            }
            state.update();
        }
        if (mechanism.matches("skull_skin")) {
            BlockState blockState = this.getBlockState();
            Material material = this.getBlock().getType();
            if (blockState instanceof Skull) {
                PlayerProfile profile;
                ListTag list3 = mechanism.valueAsType(ListTag.class);
                String idString = list3.get(0);
                String texture = null;
                if (list3.size() > 1) {
                    texture = list3.get(1);
                }
                if (idString.contains("-")) {
                    UUID uuid = UUID.fromString(idString);
                    String name = null;
                    if (list3.size() > 2) {
                        name = list3.get(2);
                    }
                    profile = new PlayerProfile(name, uuid, texture);
                } else {
                    profile = new PlayerProfile(idString, null, texture);
                }
                if (texture == null || profile.getUniqueId() == null) {
                    profile = NMSHandler.instance.fillPlayerProfile(profile);
                }
                if (texture != null) {
                    profile.setTexture(texture);
                }
                NMSHandler.blockHelper.setPlayerProfile((Skull)blockState, profile);
            } else {
                Debug.echoError("Unable to set skull_skin on block of type " + material.name() + " with state " + blockState.getClass().getCanonicalName());
            }
        }
        if (mechanism.matches("hive_max_bees") && mechanism.requireInteger()) {
            hive = (Beehive)this.getBlockState();
            hive.setMaxEntities(mechanism.getValue().asInt());
            hive.update();
        }
        if (mechanism.matches("release_bees")) {
            hive = (Beehive)this.getBlockState();
            hive.releaseEntities();
            hive.update();
        }
        if (mechanism.matches("add_bee") && mechanism.requireObject(EntityTag.class)) {
            hive = (Beehive)this.getBlockState();
            hive.addEntity((Entity)((Bee)mechanism.valueAsType(EntityTag.class).getBukkitEntity()));
            hive.update();
        }
        if (mechanism.matches("command_block_name") && this.getBlock().getState() instanceof CommandBlock) {
            block = (CommandBlock)this.getBlockState();
            block.setName(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("command_block") && this.getBlock().getState() instanceof CommandBlock) {
            block = (CommandBlock)this.getBlockState();
            block.setCommand(mechanism.getValue().asString());
            block.update();
        }
        if (mechanism.matches("custom_name") && this.getBlockState() instanceof Nameable) {
            String title = null;
            if (mechanism.hasValue()) {
                title = mechanism.getValue().asString();
            }
            BlockState state2 = this.getBlockState();
            AdvancedTextImpl.instance.setCustomName((Nameable)state2, title);
            state2.update(true);
        }
        if (mechanism.matches("brewing_time") && this.getBlockState() instanceof BrewingStand) {
            stand = (BrewingStand)this.getBlockState();
            stand.setBrewingTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
            stand.update();
        }
        if (mechanism.matches("brewing_fuel_level") && this.getBlockState() instanceof BrewingStand) {
            stand = (BrewingStand)this.getBlockState();
            stand.setFuelLevel(mechanism.getValue().asInt());
            stand.update();
        }
        if (mechanism.matches("furnace_burn_duration") && mechanism.requireObject(DurationTag.class) && this.getBlockState() instanceof Furnace) {
            furnace = (Furnace)this.getBlockState();
            furnace.setBurnTime((short)mechanism.valueAsType(DurationTag.class).getTicks());
            furnace.update();
        }
        if (mechanism.matches("furnace_burn_time")) {
            BukkitImplDeprecations.furnaceTimeTags.warn(mechanism.context);
            if (this.getBlockState() instanceof Furnace) {
                furnace = (Furnace)this.getBlockState();
                furnace.setBurnTime((short)mechanism.getValue().asInt());
                furnace.update();
            }
        }
        if (mechanism.matches("furnace_cook_duration") && this.getBlockState() instanceof Furnace) {
            furnace = (Furnace)this.getBlockState();
            furnace.setCookTime((short)mechanism.valueAsType(DurationTag.class).getTicks());
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time")) {
            BukkitImplDeprecations.furnaceTimeTags.warn(mechanism.context);
            if (this.getBlockState() instanceof Furnace) {
                furnace = (Furnace)this.getBlockState();
                furnace.setCookTime((short)mechanism.getValue().asInt());
                furnace.update();
            }
        }
        if (mechanism.matches("furnace_cook_duration_total") && this.getBlockState() instanceof Furnace) {
            furnace = (Furnace)this.getBlockState();
            furnace.setCookTimeTotal((int)((short)mechanism.valueAsType(DurationTag.class).getTicks()));
            furnace.update();
        }
        if (mechanism.matches("furnace_cook_time_total")) {
            BukkitImplDeprecations.furnaceTimeTags.warn(mechanism.context);
            if (this.getBlockState() instanceof Furnace) {
                furnace = (Furnace)this.getBlockState();
                furnace.setCookTimeTotal((int)((short)mechanism.getValue().asInt()));
                furnace.update();
            }
        }
        if (mechanism.matches("patterns")) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            list = mechanism.valueAsType(ListTag.class);
            for (String string : list) {
                try {
                    List<String> split = CoreUtilities.split(string, '/', 2);
                    patterns.add(new Pattern(DyeColor.valueOf((String)split.get(0).toUpperCase()), PatternType.valueOf((String)split.get(1).toUpperCase())));
                }
                catch (Exception e) {
                    Debug.echoError("Could not apply pattern to banner: " + string);
                }
            }
            Banner banner = (Banner)this.getBlockState();
            banner.setPatterns(patterns);
            banner.update();
        }
        if (mechanism.matches("head_rotation") && mechanism.requireInteger()) {
            Skull sk = (Skull)this.getBlockState();
            sk.setRotation(this.getSkullBlockFace(mechanism.getValue().asInt() - 1));
            sk.update();
        }
        if (mechanism.matches("generate_tree") && mechanism.requireEnum(TreeType.class) && !(generated = this.getWorld().generateTree((Location)this, TreeType.valueOf((String)mechanism.getValue().asString().toUpperCase())))) {
            Debug.echoError("Could not generate tree at " + this.identifySimple() + ". Make sure this location can naturally generate a tree!");
        }
        if (mechanism.matches("beacon_primary_effect")) {
            Beacon beacon = (Beacon)this.getBlockState();
            beacon.setPrimaryEffect(PotionEffectType.getByName((String)mechanism.getValue().asString().toUpperCase()));
            beacon.update();
        }
        if (mechanism.matches("beacon_secondary_effect")) {
            Beacon beacon = (Beacon)this.getBlockState();
            beacon.setSecondaryEffect(PotionEffectType.getByName((String)mechanism.getValue().asString().toUpperCase()));
            beacon.update();
        }
        if (mechanism.matches("activate")) {
            BlockState state3 = this.getBlockState();
            if (state3 instanceof Dispenser) {
                ((Dispenser)state3).dispense();
            } else if (state3 instanceof Dropper) {
                ((Dropper)state3).drop();
            } else {
                Debug.echoError("'activate' mechanism does not work for blocks of type: " + state3.getType().name());
            }
        }
        if (mechanism.matches("lectern_page") && mechanism.requireInteger()) {
            BlockState state4 = this.getBlockState();
            if (state4 instanceof Lectern) {
                ((Lectern)state4).setPage(mechanism.getValue().asInt());
                state4.update();
            } else {
                Debug.echoError("'lectern_page' mechanism can only be called on a lectern block.");
            }
        }
        if (mechanism.matches("clear_loot_table")) {
            BlockState state5 = this.getBlockState();
            if (state5 instanceof Lootable) {
                ((Lootable)state5).setLootTable(null);
                state5.update();
            } else {
                Debug.echoError("'clear_loot_table' mechanism can only be called on a lootable block (like a chest).");
            }
        }
        if (mechanism.matches("jukebox_record")) {
            BlockState state6 = this.getBlockState();
            if (state6 instanceof Jukebox) {
                if (mechanism.hasValue() && mechanism.requireObject(ItemTag.class)) {
                    ((Jukebox)state6).setRecord(mechanism.valueAsType(ItemTag.class).getItemStack());
                } else {
                    NMSHandler.blockHelper.makeBlockStateRaw(state6);
                    ((Jukebox)state6).setRecord(null);
                }
                state6.update();
            } else {
                Debug.echoError("'jukebox_record' mechanism can only be called on a jukebox block.");
            }
        }
        if (mechanism.matches("jukebox_play") && mechanism.requireBoolean()) {
            BlockState state7 = this.getBlockState();
            if (state7 instanceof Jukebox) {
                if (mechanism.getValue().asBoolean()) {
                    Material mat = ((Jukebox)state7).getRecord().getType();
                    if (mat == Material.AIR) {
                        Debug.echoError("'jukebox_play' cannot play nothing.");
                        return;
                    }
                    ((Jukebox)state7).setPlaying(mat);
                } else {
                    ((Jukebox)state7).stopPlaying();
                }
                state7.update();
            } else {
                Debug.echoError("'jukebox_play' mechanism can only be called on a jukebox block.");
            }
        }
        if (mechanism.matches("age") && mechanism.requireObject(DurationTag.class)) {
            BlockState state8 = this.getBlockState();
            if (state8 instanceof EndGateway) {
                ((EndGateway)state8).setAge(mechanism.valueAsType(DurationTag.class).getTicks());
                state8.update();
            } else {
                Debug.echoError("'age' mechanism can only be called on end gateway blocks.");
            }
        }
        if (mechanism.matches("is_exact_teleport") && mechanism.requireBoolean()) {
            BlockState state9 = this.getBlockState();
            if (state9 instanceof EndGateway) {
                ((EndGateway)state9).setExactTeleport(mechanism.getValue().asBoolean());
                state9.update();
            } else {
                Debug.echoError("'is_exact_teleport' mechanism can only be called on end gateway blocks.");
            }
        }
        if (mechanism.matches("exit_location") && mechanism.requireObject(LocationTag.class)) {
            BlockState state10 = this.getBlockState();
            if (state10 instanceof EndGateway) {
                ((EndGateway)state10).setExitLocation((Location)mechanism.valueAsType(LocationTag.class));
                state10.update();
            } else {
                Debug.echoError("'exit_location' mechanism can only be called on end gateway blocks.");
            }
        }
        if (mechanism.matches("vanilla_tick")) {
            NMSHandler.blockHelper.doRandomTick(this);
        }
        if (mechanism.matches("apply_bonemeal") && mechanism.requireEnum(BlockFace.class)) {
            this.getBlock().applyBoneMeal(BlockFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("campfire_items") && mechanism.requireObject(ListTag.class)) {
            BlockState state11 = this.getBlockState();
            if (!(state11 instanceof Campfire)) {
                Debug.echoError("'campfire_items' mechanism can only be called on campfire blocks.");
            } else {
                Campfire fire = (Campfire)state11;
                List<ItemTag> list4 = mechanism.valueAsType(ListTag.class).filter(ItemTag.class, mechanism.context);
                for (int i = 0; i < list4.size(); ++i) {
                    if (i >= fire.getSize()) {
                        Debug.echoError("Cannot add item for index " + (i + 1) + " as the campfire can only hold " + fire.getSize() + " items.");
                        break;
                    }
                    fire.setItem(i, list4.get(i).getItemStack());
                }
                fire.update();
            }
        }
        if (mechanism.matches("ring_bell")) {
            BlockState state12 = this.getBlockState();
            if (!(state12 instanceof Bell)) {
                Debug.echoError("'ring_bell' mechanism can only be called on Bell blocks.");
            } else {
                NMSHandler.blockHelper.ringBell((Bell)state12);
            }
        }
        if (mechanism.matches("sign_glowing") && mechanism.requireBoolean()) {
            BlockState state13 = this.getBlockState();
            if (!(state13 instanceof Sign)) {
                Debug.echoError("'sign_glowing' mechanism can only be called on Sign blocks.");
            } else {
                sign = (Sign)state13;
                sign.setGlowingText(mechanism.getValue().asBoolean());
                sign.update();
            }
        }
        if (mechanism.matches("sign_glow_color") && mechanism.requireEnum(DyeColor.class)) {
            BlockState state14 = this.getBlockState();
            if (!(state14 instanceof Sign)) {
                Debug.echoError("'sign_glow_color' mechanism can only be called on Sign blocks.");
            } else {
                sign = (Sign)state14;
                sign.setColor(mechanism.getValue().asEnum(DyeColor.class));
                sign.update();
            }
        }
        if (mechanism.matches("structure_block_data") && mechanism.requireObject(MapTag.class)) {
            ObjectTag showInvisible;
            ObjectTag ignoreEntities;
            ObjectTag boxVisible;
            ObjectTag mode;
            ObjectTag size;
            ObjectTag structureName;
            ObjectTag seed;
            ObjectTag rotation;
            ObjectTag boxPosition;
            ObjectTag mirror;
            ObjectTag metadata;
            ObjectTag integrity;
            BlockState state15 = this.getBlockState();
            if (!(state15 instanceof Structure)) {
                mechanism.echoError("'structure_block_data' mechanism can only be called on Structure blocks.");
                return;
            }
            Structure structure = (Structure)state15;
            MapTag input = mechanism.valueAsType(MapTag.class);
            ObjectTag author = input.getObject("author");
            if (author != null) {
                if (author.shouldBeType(EntityTag.class)) {
                    EntityTag entity = author.asType(EntityTag.class, mechanism.context);
                    if (!entity.isLivingEntity()) {
                        mechanism.echoError("Invalid author entity input '" + author + "': entity must be living.");
                        return;
                    }
                    structure.setAuthor(entity.getLivingEntity());
                } else {
                    structure.setAuthor(author.toString());
                }
            }
            if ((integrity = input.getObject("integrity")) != null) {
                float integrityFloat;
                ElementTag integrityElement = integrity.asElement();
                float f = integrityFloat = integrityElement.isFloat() ? integrityElement.asFloat() : -1.0f;
                if (integrityFloat < 0.0f || integrityFloat > 1.0f) {
                    mechanism.echoError("Invalid integrity input '" + integrity + "': must be a decimal between 0 and 1.");
                    return;
                }
                structure.setIntegrity(integrityFloat);
            }
            if ((metadata = input.getObject("metadata")) != null) {
                if (structure.getUsageMode() != UsageMode.DATA) {
                    mechanism.echoError("metadata can only be set while in DATA mode.");
                    return;
                }
                structure.setMetadata(metadata.toString());
            }
            if ((mirror = input.getObject("mirror")) != null) {
                Mirror mirrorEnum = mirror.asElement().asEnum(Mirror.class);
                if (mirrorEnum == null) {
                    mechanism.echoError("Invalid mirror input '" + mirror + "': check meta docs for more information.");
                    return;
                }
                structure.setMirror(mirrorEnum);
            }
            if ((boxPosition = input.getObject("box_position")) != null) {
                LocationTag boxPositionLoc = boxPosition.asType(LocationTag.class, mechanism.context);
                if (boxPositionLoc == null) {
                    mechanism.echoError("Invalid box_position input '" + boxPosition + "': must be a LocationTag.");
                    return;
                }
                int x = boxPositionLoc.getBlockX();
                int y = boxPositionLoc.getBlockY();
                int z = boxPositionLoc.getBlockZ();
                if (x < -48 || x > 48 || y < -48 || y > 48 || z < -48 || z > 48) {
                    mechanism.echoError("Invalid box_position input '" + boxPosition + "': must be within 48 blocks of the structure block.");
                    return;
                }
                structure.setRelativePosition(new BlockVector(boxPositionLoc.toVector()));
            }
            if ((rotation = input.getObject("rotation")) != null) {
                StructureRotation rotationEnum = rotation.asElement().asEnum(StructureRotation.class);
                if (rotationEnum == null) {
                    mechanism.echoError("Invalid rotation input '" + rotation + "': check meta docs for more information.");
                    return;
                }
                structure.setRotation(rotationEnum);
            }
            if ((seed = input.getObject("seed")) != null) {
                ElementTag seedElement = seed.asElement();
                if (!seedElement.isInt()) {
                    mechanism.echoError("Invalid seed input '" + seed + "': must be an integer.");
                    return;
                }
                structure.setSeed(seedElement.asLong());
            }
            if ((structureName = input.getObject("structure_name")) != null) {
                structure.setStructureName(structureName.toString());
            }
            if ((size = input.getObject("size")) != null) {
                LocationTag sizeLoc = size.asType(LocationTag.class, mechanism.context);
                if (sizeLoc == null) {
                    mechanism.echoError("Invalid size input '" + size + "': must be a LocationTag.");
                    return;
                }
                int x = sizeLoc.getBlockX();
                int y = sizeLoc.getBlockY();
                int z = sizeLoc.getBlockZ();
                if (x < 0 || x > 48 || y < 0 || y > 48 || z < 0 || z > 48) {
                    mechanism.echoError("Invalid size input '" + size + "': cannot be larger than 48,48,48 or smaller than 0,0,0.");
                    return;
                }
                structure.setStructureSize(new BlockVector(sizeLoc.toVector()));
            }
            if ((mode = input.getObject("mode")) != null) {
                UsageMode usageMode = mode.asElement().asEnum(UsageMode.class);
                if (usageMode == null) {
                    mechanism.echoError("Invalid mode input '" + mode + "': check meta docs for more information.");
                    return;
                }
                structure.setUsageMode(usageMode);
            }
            if ((boxVisible = input.getObject("box_visible")) != null) {
                ElementTag boxVisibleElement = boxVisible.asElement();
                if (!boxVisibleElement.isBoolean()) {
                    mechanism.echoError("Invalid box_visible input '" + boxVisible + "': must be a boolean.");
                    return;
                }
                structure.setBoundingBoxVisible(boxVisibleElement.asBoolean());
            }
            if ((ignoreEntities = input.getObject("ignore_entities")) != null) {
                ElementTag ignoreEntitiesElement = ignoreEntities.asElement();
                if (!ignoreEntitiesElement.isBoolean()) {
                    mechanism.echoError("Invalid ignore_entities input '" + ignoreEntities + "': must be a boolean.");
                    return;
                }
                structure.setIgnoreEntities(ignoreEntitiesElement.asBoolean());
            }
            if ((showInvisible = input.getObject("show_invisible")) != null) {
                ElementTag showInvisibleElement = showInvisible.asElement();
                if (!showInvisibleElement.isBoolean()) {
                    mechanism.echoError("Invalid show_invisible input '" + showInvisible + "': must be a boolean.");
                    return;
                }
                structure.setShowAir(showInvisibleElement.asBoolean());
            }
            structure.update();
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    @Override
    public boolean advancedMatches(String matcher) {
        String matcherLow = CoreUtilities.toLowerCase(matcher);
        if (matcherLow.equals("location")) {
            return true;
        }
        if (matcherLow.contains(":")) {
            if (matcherLow.startsWith("block_flagged:")) {
                return BukkitScriptEvent.coreFlaggedCheck(matcher.substring("block_flagged:".length()), this.getFlagTracker());
            }
            if (matcherLow.startsWith("location_in:")) {
                return BukkitScriptEvent.inCheckInternal(CoreUtilities.noDebugContext, "tryLocation", this, matcher.substring("location_in:".length()), "tryLocation", "tryLocation");
            }
        }
        if (this.getWorld() == null) {
            return false;
        }
        if (this.getY() < (double)this.getWorld().getMinHeight() || this.getY() >= (double)this.getWorld().getMaxHeight()) {
            return false;
        }
        return MaterialTag.advancedMatchesInternal(this.getBlock().getType(), matcher, true);
    }

    public static class FloodFiller {
        public Set<LocationTag> result;
        public int iterationLimit;
        public AreaContainmentObject areaLimit;
        public Material requiredMaterial;
        public String matcher;

        public void run(LocationTag start, AreaContainmentObject area) {
            this.iterationLimit = Settings.blockTagsMaxBlocks();
            this.areaLimit = area;
            this.result = new LinkedHashSet<LocationTag>();
            this.flood(start.getBlockLocation());
        }

        public void flood(LocationTag loc) {
            if (this.iterationLimit-- <= 0 || this.result.contains(loc) || !this.areaLimit.doesContainLocation(loc)) {
                return;
            }
            if (!loc.isChunkLoaded()) {
                return;
            }
            if (this.matcher == null ? loc.getBlock().getType() != this.requiredMaterial : !loc.tryAdvancedMatcher(this.matcher)) {
                return;
            }
            this.result.add(loc);
            this.flood(loc.clone().add(-1.0, 0.0, 0.0));
            this.flood(loc.clone().add(1.0, 0.0, 0.0));
            this.flood(loc.clone().add(0.0, 0.0, -1.0));
            this.flood(loc.clone().add(0.0, 0.0, 1.0));
            this.flood(loc.clone().add(0.0, -1.0, 0.0));
            this.flood(loc.clone().add(0.0, 1.0, 0.0));
        }
    }
}

