/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.core.SQLCommand;
import com.denizenscript.denizencore.scripts.commands.queue.RunLaterCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.QueueWordList;
import com.denizenscript.denizencore.utilities.SimplexNoise;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class UtilTagBase {
    public static final long serverStartTimeMillis = CoreUtilities.monotonicMillis();

    public UtilTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                event.getAttributes().fulfill(1);
                UtilTagBase.utilTag(event);
            }
        }, "util");
    }

    public static void utilTag(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes();
        if (attribute.startsWith("random")) {
            String stc;
            if ((attribute = attribute.fulfill(1)).startsWith("int")) {
                stc = attribute.getParam();
                if ((attribute = attribute.fulfill(1)).startsWith("to") && ArgumentHelper.matchesInteger(stc) && ArgumentHelper.matchesInteger(attribute.getParam())) {
                    int max;
                    int min = Integer.parseInt(stc);
                    if (min > (max = attribute.getIntParam())) {
                        int store = min;
                        min = max;
                        max = store;
                    }
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(String.valueOf(CoreUtilities.getRandom().nextInt(max - min + 1) + min)), attribute.fulfill(1)));
                }
            }
            if (attribute.startsWith("decimal") && attribute.hasParam()) {
                stc = attribute.getParam();
                if ((attribute = attribute.fulfill(1)).startsWith("to") && ArgumentHelper.matchesDouble(stc) && ArgumentHelper.matchesDouble(attribute.getParam())) {
                    double max;
                    double min = Double.parseDouble(stc);
                    if (min > (max = Double.parseDouble(attribute.getParam()))) {
                        double store = min;
                        min = max;
                        max = store;
                    }
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(String.valueOf(CoreUtilities.getRandom().nextDouble() * (max - min) + min)), attribute.fulfill(1)));
                }
            } else if (attribute.startsWith("decimal")) {
                Deprecations.oldUtilRandomTags.warn(attribute.context);
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextDouble()), attribute.fulfill(1)));
            } else if (attribute.startsWith("boolean")) {
                Deprecations.oldUtilRandomTags.warn(attribute.context);
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextBoolean()), attribute.fulfill(1)));
            } else if (attribute.startsWith("gauss")) {
                Deprecations.oldUtilRandomTags.warn(attribute.context);
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextGaussian()), attribute.fulfill(1)));
            } else if (attribute.startsWith("uuid")) {
                Deprecations.oldUtilRandomTags.warn(attribute.context);
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(UUID.randomUUID().toString()), attribute.fulfill(1)));
            } else if (attribute.startsWith("duuid")) {
                int size = QueueWordList.FinalWordList.size();
                String id = (attribute.hasParam() ? attribute.getParam() : "DUUID") + "_" + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size)) + QueueWordList.FinalWordList.get(CoreUtilities.getRandom().nextInt(size));
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(id), attribute.fulfill(1)));
            }
        } else if (attribute.startsWith("random_decimal")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextDouble()), attribute.fulfill(1)));
        } else if (attribute.startsWith("random_chance") && attribute.hasParam()) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextDouble() * 100.0 <= attribute.getDoubleParam()), attribute.fulfill(1)));
        } else if (attribute.startsWith("random_boolean")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextBoolean()), attribute.fulfill(1)));
        } else if (attribute.startsWith("random_gauss")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(CoreUtilities.getRandom().nextGaussian()), attribute.fulfill(1)));
        } else if (attribute.startsWith("random_uuid")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(UUID.randomUUID().toString()), attribute.fulfill(1)));
        } else if (attribute.startsWith("random_simplex") && attribute.hasParam()) {
            MapTag input = attribute.inputParameterMap();
            ElementTag objX = input.getRequiredObjectAs("x", ElementTag.class, attribute);
            ObjectTag objY = input.getObject("y");
            ObjectTag objZ = input.getObject("z");
            ObjectTag objW = input.getObject("w");
            double x = objX == null ? 0.0 : objX.asElement().asDouble();
            double y = objY == null ? 0.0 : objY.asElement().asDouble();
            double z = objZ == null ? 0.0 : objZ.asElement().asDouble();
            double w = objW == null ? 0.0 : objW.asElement().asDouble();
            double res = 0.0;
            if (objW != null && objZ != null && objY != null && objX != null) {
                res = SimplexNoise.noise(x, y, z, w);
            } else if (objZ != null && objY != null && objX != null && objW == null) {
                res = SimplexNoise.noise(x, y, z);
            } else if (objY != null && objX != null && objW == null && objZ == null) {
                res = SimplexNoise.noise(y, x);
            } else if (objX != null && objW == null && objZ == null && objY == null) {
                res = SimplexNoise.noise(y, x);
            } else {
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(res), attribute.fulfill(1)));
        } else if (attribute.startsWith("list_numbers") && attribute.hasParam()) {
            MapTag input = attribute.inputParameterMap();
            ElementTag toElement = input.getRequiredObjectAs("to", ElementTag.class, attribute);
            if (toElement == null || !toElement.isInt()) {
                return;
            }
            long to = toElement.asInt();
            long from = input.getElement("from", "1").asInt();
            long every = input.getElement("every", "1").asInt();
            ListTag result = new ListTag();
            for (long i = from; i <= to; i += every) {
                result.addObject(new ElementTag(i));
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(result, attribute.fulfill(1)));
        } else if (attribute.startsWith("list_numbers_to") && attribute.hasParam()) {
            int to = attribute.getIntParam();
            ListTag result = new ListTag();
            for (int i = 1; i <= to; ++i) {
                result.add(String.valueOf(i));
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(result, attribute.fulfill(1)));
        } else if (attribute.startsWith("empty_list_entries") && attribute.hasParam()) {
            int to = attribute.getIntParam();
            ListTag result = new ListTag();
            for (int i = 1; i <= to; ++i) {
                result.add("");
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(result, attribute.fulfill(1)));
        } else if (attribute.startsWith("short_max")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Short.MAX_VALUE), attribute.fulfill(1)));
        } else if (attribute.startsWith("short_min")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Short.MIN_VALUE), attribute.fulfill(1)));
        } else if (attribute.startsWith("int_max")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Integer.MAX_VALUE), attribute.fulfill(1)));
        } else if (attribute.startsWith("int_min")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Integer.MIN_VALUE), attribute.fulfill(1)));
        } else if (attribute.startsWith("long_max")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Long.MAX_VALUE), attribute.fulfill(1)));
        } else if (attribute.startsWith("long_min")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Long.MIN_VALUE), attribute.fulfill(1)));
        } else if (attribute.startsWith("pi")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Math.PI), attribute.fulfill(1)));
        } else if (attribute.startsWith("tau")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Math.PI * 2), attribute.fulfill(1)));
        } else if (attribute.matches("e")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Math.E), attribute.fulfill(1)));
        } else if (attribute.startsWith("list_denizen_commands")) {
            ListTag result = new ListTag(DenizenCore.commandRegistry.instances.keySet());
            event.setReplacedObject(CoreUtilities.autoAttrib(result, attribute.fulfill(1)));
        } else if (attribute.startsWith("list_tag_bases")) {
            ListTag result = new ListTag(TagManager.baseTags.keySet());
            event.setReplacedObject(CoreUtilities.autoAttrib(result, attribute.fulfill(1)));
        } else if (attribute.matches("time_at") && attribute.hasParam()) {
            Deprecations.timeTagRewrite.warn(attribute.context);
            String[] dateComponents = attribute.getParam().split(" ");
            String[] ymd = dateComponents[0].split("/");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]) - 1;
            int day = Integer.parseInt(ymd[2]);
            int hour = 0;
            int minute = 0;
            int second = 0;
            int millisecond = 0;
            if (dateComponents.length > 1) {
                String[] hms = dateComponents[1].split(":");
                hour = Integer.parseInt(hms[0]);
                minute = Integer.parseInt(hms[1]);
                second = Integer.parseInt(hms[2]);
                if (hms.length > 3) {
                    millisecond = Integer.parseInt(hms[3]);
                }
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, hour, minute, second);
            TimeTag result = new TimeTag(calendar.getTimeInMillis() + (long)millisecond);
            event.setReplacedObject(result.getObjectAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("time_now")) {
            event.setReplacedObject(TimeTag.now().getObjectAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("date")) {
            Deprecations.timeTagRewrite.warn(attribute.context);
            Calendar calendar = Calendar.getInstance();
            Date currentDate = new Date();
            SimpleDateFormat format = new SimpleDateFormat();
            attribute = attribute.fulfill(1);
            if (attribute.startsWith("time")) {
                TimeZone tz;
                if ((attribute = attribute.fulfill(1)).startsWith("twentyfour_hour")) {
                    format.applyPattern("k:mm");
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute.fulfill(1)));
                } else if (attribute.startsWith("year")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(1)), attribute.fulfill(1)));
                } else if (attribute.startsWith("month")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(2) + 1), attribute.fulfill(1)));
                } else if (attribute.startsWith("week")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(3)), attribute.fulfill(1)));
                } else if (attribute.startsWith("day_of_week")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(7)), attribute.fulfill(1)));
                } else if (attribute.startsWith("day")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(5)), attribute.fulfill(1)));
                } else if (attribute.startsWith("hour")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(11)), attribute.fulfill(1)));
                } else if (attribute.startsWith("minute")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(12)), attribute.fulfill(1)));
                } else if (attribute.startsWith("second")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(calendar.get(13)), attribute.fulfill(1)));
                } else if (attribute.startsWith("duration")) {
                    event.setReplacedObject(CoreUtilities.autoAttrib(new DurationTag(System.currentTimeMillis() / 50L), attribute.fulfill(1)));
                } else if (attribute.startsWith("zone")) {
                    tz = Calendar.getInstance().getTimeZone();
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(tz.getDisplayName(tz.inDaylightTime(currentDate), 0)), attribute.fulfill(1)));
                } else if (attribute.startsWith("formatted_zone")) {
                    tz = Calendar.getInstance().getTimeZone();
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(tz.getDisplayName(tz.inDaylightTime(currentDate), 1)), attribute.fulfill(1)));
                } else {
                    format.applyPattern("K:mm a");
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute));
                }
            } else if (attribute.startsWith("format") && attribute.hasParam()) {
                try {
                    format.applyPattern(attribute.getParam());
                    event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute.fulfill(1)));
                }
                catch (Exception ex) {
                    Debug.echoError("Error: invalid pattern '" + attribute.getParam() + "'");
                    Debug.echoError(ex);
                }
            } else {
                format.applyPattern("EEE, MMM d, yyyy");
                event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(format.format(currentDate)), attribute));
            }
        } else if (attribute.matches("parse_yaml") && attribute.hasParam()) {
            ObjectTag tagForm = CoreUtilities.objectToTagForm(YamlConfiguration.load((String)attribute.getParam()).contents, attribute.context);
            event.setReplacedObject(CoreUtilities.autoAttrib(tagForm, attribute.fulfill(1)));
        } else if (attribute.startsWith("queues")) {
            ListTag list = new ListTag();
            for (ScriptQueue queue : ScriptQueue.getQueues()) {
                list.addObject(new QueueTag(queue));
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(list, attribute.fulfill(1)));
        } else if (attribute.startsWith("event_stats")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(ScriptQueue.getStats()), attribute.fulfill(1)));
        } else if (attribute.startsWith("event_stats_data")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(ScriptQueue.getStatsRawData(), attribute.fulfill(1)));
        } else if (attribute.startsWith("default_encoding")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(Charset.defaultCharset().name()), attribute.fulfill(1)));
        } else if (attribute.startsWith("runlater_ids")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ListTag(new ArrayList<String>(RunLaterCommand.trackedById.keySet()), true), attribute.fulfill(1)));
        } else if (attribute.startsWith("java_version")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(System.getProperty("java.version")), attribute.fulfill(1)));
        } else if (attribute.startsWith("has_file") && attribute.hasParam()) {
            File f = new File(DenizenCore.implementation.getDataFolder(), attribute.getParam());
            try {
                if (!DenizenCore.implementation.canReadFile(f)) {
                    Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
                    return;
                }
            }
            catch (Exception e) {
                Debug.echoError(e);
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(f.exists()), attribute.fulfill(1)));
        } else if (attribute.startsWith("list_files") && attribute.hasParam()) {
            File folder = new File(DenizenCore.implementation.getDataFolder(), attribute.getParam());
            try {
                if (!DenizenCore.implementation.canReadFile(folder)) {
                    Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
                    return;
                }
                if (!folder.exists() || !folder.isDirectory()) {
                    attribute.echoError("Invalid path specified. No directory exists at that path.");
                    return;
                }
            }
            catch (Exception e) {
                Debug.echoError(e);
                return;
            }
            File[] files = folder.listFiles();
            if (files == null) {
                return;
            }
            ListTag list = new ListTag();
            for (File file : files) {
                list.add(file.getName());
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(list, attribute.fulfill(1)));
        }
        if (attribute.startsWith("started_time")) {
            event.setReplacedObject(new TimeTag(CoreUtilities.monotonicMillisToReal(DenizenCore.startTime)).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("disk_free")) {
            File folder = DenizenCore.implementation.getDataFolder();
            event.setReplacedObject(new ElementTag(folder.getUsableSpace()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("disk_total")) {
            File folder = DenizenCore.implementation.getDataFolder();
            event.setReplacedObject(new ElementTag(folder.getTotalSpace()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("disk_usage")) {
            File folder = DenizenCore.implementation.getDataFolder();
            event.setReplacedObject(new ElementTag(folder.getTotalSpace() - folder.getFreeSpace()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("ram_allocated")) {
            event.setReplacedObject(new ElementTag(Runtime.getRuntime().totalMemory()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("ram_max")) {
            event.setReplacedObject(new ElementTag(Runtime.getRuntime().maxMemory()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("ram_free")) {
            event.setReplacedObject(new ElementTag(Runtime.getRuntime().freeMemory()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("ram_usage")) {
            event.setReplacedObject(new ElementTag(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("available_processors")) {
            event.setReplacedObject(new ElementTag(Runtime.getRuntime().availableProcessors()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("current_tick")) {
            event.setReplacedObject(new ElementTag(TickScriptEvent.instance.ticks).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("delta_time_since_start")) {
            event.setReplacedObject(new DurationTag(TickScriptEvent.instance.ticks).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("real_time_since_start")) {
            event.setReplacedObject(new DurationTag((double)(CoreUtilities.monotonicMillis() - serverStartTimeMillis) / 1000.0).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("current_time_millis")) {
            event.setReplacedObject(new ElementTag(System.currentTimeMillis()).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("notes")) {
            ListTag allNotables = new ListTag();
            if (attribute.hasParam()) {
                String type = CoreUtilities.toLowerCase(attribute.getParam());
                for (Map.Entry<String, Class> typeClass : NoteManager.namesToTypes.entrySet()) {
                    if (!type.equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                    for (Object notable : NoteManager.getAllType(typeClass.getValue())) {
                        allNotables.addObject((ObjectTag)notable);
                    }
                    break;
                }
            } else {
                for (Notable notable : NoteManager.nameToObject.values()) {
                    allNotables.addObject((ObjectTag)((Object)notable));
                }
            }
            event.setReplacedObject(allNotables.getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("sql_connections")) {
            ListTag list = new ListTag();
            for (Map.Entry<String, Connection> entry : SQLCommand.connections.entrySet()) {
                try {
                    if (!entry.getValue().isClosed()) {
                        list.add(entry.getKey());
                        continue;
                    }
                    SQLCommand.connections.remove(entry.getKey());
                }
                catch (SQLException e) {
                    Debug.echoError(attribute.getScriptEntry(), e);
                }
            }
            event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("scripts")) {
            ListTag scripts = new ListTag();
            for (ScriptContainer script : ScriptRegistry.scriptContainers.values()) {
                scripts.addObject(new ScriptTag(script));
            }
            event.setReplacedObject(scripts.getObjectAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("last_reload")) {
            event.setReplacedObject(new TimeTag(CoreUtilities.monotonicMillisToReal(DenizenCore.lastReloadTime)).getObjectAttribute(attribute.fulfill(1)));
        }
    }

    public static void adjustSystem(Mechanism mechanism) {
        RunLaterCommand.FutureRunData runner;
        if (mechanism.matches("redirect_logging") && mechanism.hasValue()) {
            if (!CoreConfiguration.allowConsoleRedirection) {
                Debug.echoError("Console redirection disabled by administrator (refer to mechanism documentation).");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }
        if (mechanism.matches("cancel_runlater") && mechanism.hasValue() && (runner = RunLaterCommand.trackedById.remove(CoreUtilities.toLowerCase(mechanism.getValue().asString()))) != null) {
            runner.cancelled = true;
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

