/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BinaryTag
implements ObjectTag {
    public static byte[] EMPTY = new byte[0];
    public static AsciiMatcher VALID_HEX = new AsciiMatcher("0123456789abcdefABCDEF");
    public byte[] data;
    private String prefix = "Binary";
    public static ObjectTagProcessor<BinaryTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="binary")
    public static BinaryTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("binary@")) {
            string = string.substring("binary@".length());
        }
        if (string.isEmpty()) {
            return new BinaryTag(EMPTY);
        }
        if (!VALID_HEX.isOnlyMatches(string)) {
            return null;
        }
        if (string.length() % 2 == 1) {
            return null;
        }
        return new BinaryTag(CoreUtilities.hexDecode(string));
    }

    public static boolean matches(String string) {
        try {
            if (string.startsWith("binary@")) {
                return true;
            }
            if (!VALID_HEX.isOnlyMatches(string)) {
                return false;
            }
            return string.length() % 2 != 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BinaryTag(byte[] data) {
        this.data = data;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static String hexEncode(byte[] data, boolean spaced) {
        if (!spaced) {
            return CoreUtilities.hexEncode(data);
        }
        char[] output = new char[data.length * 3];
        for (int i = 0; i < data.length; ++i) {
            byte valA = (byte)((data[i] & 0xF0) >> 4);
            byte valB = (byte)(data[i] & 0xF);
            output[i * 3] = CoreUtilities.charForByte[valA];
            output[i * 3 + 1] = CoreUtilities.charForByte[valB];
            output[i * 3 + 2] = 32;
        }
        return new String(output);
    }

    @Override
    public String debuggable() {
        return "binary@<GR>" + BinaryTag.hexEncode(this.data, true);
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "binary";
    }

    @Override
    public String identify() {
        return "binary@" + BinaryTag.hexEncode(this.data, false);
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        tagProcessor.registerStaticTag(ElementTag.class, "length", (attribute, object) -> new ElementTag(object.data.length), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_hex", (attribute, object) -> new ElementTag(BinaryTag.hexEncode(object.data, false)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "to_base64", (attribute, object) -> new ElementTag(Base64.getEncoder().encodeToString(object.data)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "utf8_decode", (attribute, object) -> new ElementTag(new String(object.data, StandardCharsets.UTF_8)), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "text_decode", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            try {
                return new ElementTag(new String(object.data, attribute.getParam()));
            }
            catch (UnsupportedEncodingException ex) {
                attribute.echoError("Invalid encoding '" + attribute.getParam() + "'");
                return null;
            }
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "decode_integer", (attribute, object) -> {
            if (object.data.length == 1) {
                return new ElementTag(object.data[0]);
            }
            if (object.data.length > 8) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(object.data);
            if (object.data.length == 2) {
                return new ElementTag(buffer.getShort());
            }
            if (object.data.length == 4) {
                return new ElementTag(buffer.getInt());
            }
            if (object.data.length == 8) {
                return new ElementTag(buffer.getLong());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, "gzip_compress", (attribute, object) -> new BinaryTag(BinaryTag.compressGzip(object.data)), new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, "gzip_decompress", (attribute, object) -> new BinaryTag(BinaryTag.decompressGzip(object.data)), new String[0]);
        tagProcessor.registerStaticTag(BinaryTag.class, "hash", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            try {
                MessageDigest md = MessageDigest.getInstance(attribute.getParam());
                md.update(object.data, 0, object.data.length);
                return new BinaryTag(md.digest());
            }
            catch (Throwable ex) {
                attribute.echoError(ex);
                return null;
            }
        }, new String[0]);
    }

    private static byte[] decompressGzip(byte[] data) {
        try {
            int len;
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
            GZIPInputStream gzipIn = new GZIPInputStream(bytesIn);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(data.length);
            byte[] buffer = new byte[1024];
            while ((len = gzipIn.read(buffer, 0, 1024)) != -1) {
                bytesOut.write(buffer, 0, len);
            }
            byte[] result = bytesOut.toByteArray();
            gzipIn.close();
            bytesIn.close();
            bytesOut.close();
            return result;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    private static byte[] compressGzip(byte[] data) {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(data.length);
            GZIPOutputStream gzipOut = new GZIPOutputStream(bytesOut);
            gzipOut.write(data);
            gzipOut.finish();
            byte[] result = bytesOut.toByteArray();
            gzipOut.close();
            bytesOut.close();
            return result;
        }
        catch (IOException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

