/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClickTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void clickTrigger(NPCRightClickEvent event) {
        if (!event.getNPC().hasTrait(TriggerTrait.class)) {
            return;
        }
        NPCTag npc = new NPCTag(event.getNPC());
        if (!npc.getTriggerTrait().isEnabled(this.name)) {
            return;
        }
        TriggerTrait triggerTrait = npc.getTriggerTrait();
        double radius = triggerTrait.getRadius(this.name);
        if (radius > 0.0 && event.getClicker().getLocation().distanceSquared((Location)npc.getLocation()) > radius * radius) {
            return;
        }
        PlayerTag player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getClicker());
        TriggerTrait.TriggerContext trigger = npc.getTriggerTrait().trigger(this, player);
        if (!trigger.wasTriggered()) {
            return;
        }
        if (trigger.hasDetermination() && trigger.getDeterminations().containsCaseInsensitive("cancelled")) {
            event.setCancelled(true);
            return;
        }
        List<InteractScriptContainer> scripts = npc.getInteractScripts(player, ClickTrigger.class);
        boolean any = false;
        if (scripts != null) {
            for (InteractScriptContainer script : scripts) {
                String id = null;
                Map<String, String> idMap = script.getIdMapFor(ClickTrigger.class, player);
                if (!idMap.isEmpty()) {
                    ItemTag heldItem = new ItemTag(player.getPlayerEntity().getEquipment().getItemInMainHand());
                    for (Map.Entry<String, String> entry : idMap.entrySet()) {
                        boolean isMatch;
                        String entry_value = TagManager.tag(entry.getValue(), new BukkitTagContext(player, npc, null, false, null));
                        boolean bl = isMatch = entry_value.isEmpty() || heldItem.tryAdvancedMatcher(entry_value);
                        if (script.shouldDebug()) {
                            Debug.echoDebug((Debuggable)script, "Comparing click trigger '<A>" + entry_value + "<W>' with item '<A>" + heldItem.debuggable() + "<W>': " + (isMatch ? "<GR>Match!" : "<Y>Not a match"));
                        }
                        if (!isMatch) continue;
                        id = entry.getKey();
                        break;
                    }
                }
                if (!this.parse(npc, player, script, id)) continue;
                any = true;
            }
        }
        if (!any) {
            npc.action("no click trigger", player);
        }
    }

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }
}

