/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.debugging;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class Debug {
    public static boolean showScriptBuilder = false;
    public static boolean showEventsTrimming = false;

    public static void echoError(String error) {
        DenizenCore.implementation.debugError((String)null, error);
    }

    public static void echoError(TagContext context, String error) {
        Debug.echoError(context, null, error);
    }

    public static void echoError(TagContext context, String addedContext, String error) {
        if (context != null && context.entry != null) {
            Debug.echoError(context.entry, addedContext, error);
        } else if (context != null && context.script != null) {
            Debug.echoError(context.script.getContainer(), addedContext, error);
        } else {
            DenizenCore.implementation.debugError(addedContext, error);
        }
    }

    public static void echoError(ScriptContainer script, String error) {
        Debug.echoError(script, null, error);
    }

    public static void echoError(ScriptContainer script, String addedContext, String error) {
        if (script != null) {
            addedContext = " <LR>In script '<A>" + script.getName() + "<LR>'" + (addedContext == null ? "" : addedContext);
        }
        DenizenCore.implementation.debugError(addedContext, error);
    }

    public static void echoError(ScriptEntry entry, String error) {
        Debug.echoError(entry, null, error);
    }

    public static void echoError(ScriptEntry entry, String addedContext, String error) {
        DenizenCore.implementation.debugError(entry, addedContext, error);
    }

    public static void echoError(Throwable ex) {
        DenizenCore.implementation.debugException(ex);
    }

    public static void echoError(ScriptEntry entry, Throwable error) {
        DenizenCore.implementation.debugError(entry, error);
    }

    public static void log(String message) {
        DenizenCore.implementation.debugMessage(message);
    }

    public static void log(String caller, String message) {
        DenizenCore.implementation.debugMessage(caller, message);
    }

    public static void echoApproval(String message) {
        DenizenCore.implementation.debugApproval(message);
    }

    public static void echoDebug(Debuggable entry, String message) {
        DenizenCore.implementation.debugEntry(entry, message);
    }

    public static void echoDebug(Debuggable entry, DebugElement element, String message) {
        DenizenCore.implementation.debugEntry(entry, element, message);
    }

    public static void echoDebug(Debuggable entry, DebugElement element) {
        DenizenCore.implementation.debugEntry(entry, element);
    }

    public static void report(Debuggable caller, String name, String message) {
        DenizenCore.implementation.debugReport(caller, name, message);
    }

    public static void report(Debuggable caller, String name, Object ... values) {
        DenizenCore.implementation.debugReport(caller, name, values);
    }

    public static enum DebugElement {
        Header,
        Footer,
        Spacer;

    }
}

