/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.events.core.CustomScriptEvent;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class CustomEventCommand
extends AbstractCommand {
    public CustomEventCommand() {
        this.setName("customevent");
        this.setSyntax("customevent [id:<id>] (context:<map>)");
        this.setRequiredArguments(1, 2);
        this.isProcedural = false;
        this.setPrefixesHandled("id", "context");
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        CustomScriptEvent ranEvent;
        ElementTag id = scriptEntry.requiredArgForPrefixAsElement("id");
        MapTag context = scriptEntry.argForPrefix("context", MapTag.class, true);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), id, context);
        }
        scriptEntry.addObject("any_ran", new ElementTag((ranEvent = CustomScriptEvent.runCustomEvent(scriptEntry.entryData, CoreUtilities.toLowerCase(id.asString()), context)) != null && ranEvent.anyMatched));
        scriptEntry.addObject("was_cancelled", new ElementTag(ranEvent != null && ranEvent.cancelled));
        scriptEntry.addObject("determination_list", ranEvent == null ? new ListTag() : new ListTag(ranEvent.determinations));
    }
}

