/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.block.data.type.Scaffolding;

public class MaterialDistance
implements Property {
    public static final String[] handledMechs = new String[]{"distance"};
    MaterialTag material;

    public static boolean describes(Object material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData() instanceof Scaffolding || ((MaterialTag)material).getModernData() instanceof Leaves);
    }

    public static MaterialDistance getFrom(ObjectTag _material) {
        if (!MaterialDistance.describes(_material)) {
            return null;
        }
        return new MaterialDistance((MaterialTag)_material);
    }

    private MaterialDistance(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(ElementTag.class, "distance", (attribute, material) -> new ElementTag(material.getDistance()), new String[0]);
    }

    public int getDistance() {
        if (this.isScaffolding()) {
            return this.getScaffolding().getDistance();
        }
        if (this.isLeaves()) {
            return this.getLeaves().getDistance();
        }
        throw new UnsupportedOperationException();
    }

    public Scaffolding getScaffolding() {
        return (Scaffolding)this.material.getModernData();
    }

    public Leaves getLeaves() {
        return (Leaves)this.material.getModernData();
    }

    public boolean isScaffolding() {
        return this.material.getModernData() instanceof Scaffolding;
    }

    public boolean isLeaves() {
        return this.material.getModernData() instanceof Leaves;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getDistance());
    }

    @Override
    public String getPropertyId() {
        return "distance";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("distance") && mechanism.requireInteger()) {
            int distance = mechanism.getValue().asInt();
            if (this.isScaffolding()) {
                if (distance >= 0 && distance <= this.getScaffolding().getMaximumDistance()) {
                    this.getScaffolding().setDistance(distance);
                } else {
                    mechanism.echoError("Distance must be between 0 and " + this.getScaffolding().getMaximumDistance());
                }
            } else if (this.isLeaves()) {
                this.getLeaves().setDistance(distance);
            }
        }
    }
}

