/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityTargetsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityTargetsScriptEvent instance;
    public EntityTag entity;
    public ElementTag reason;
    public EntityTag target;
    private LocationTag location;
    public EntityTargetEvent event;

    public EntityTargetsScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> targets (<entity>) (because <'cause'>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        int index;
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        String victim = path.eventArgLowerAt(2);
        if (!(victim.equals("in") || victim.equals("because") || victim.equals("") || this.target != null && this.target.tryAdvancedMatcher(victim))) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        int n = path.eventArgLowerAt(3).equals("because") ? 3 : (index = path.eventArgAt(2).equals("because") ? 2 : -1);
        if (index > 0 && !path.eventArgLowerAt(index + 1).equals(CoreUtilities.toLowerCase(this.reason.toString()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityTargets";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (EntityTag.matches(determination)) {
            this.target = EntityTag.valueOf(determination, this.getTagContext(path));
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.target);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        if (name.equals("target") && this.target != null) {
            return this.target.getDenizenObject();
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityTargets(EntityTargetEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.reason = new ElementTag(event.getReason().toString());
        this.target = event.getTarget() != null ? new EntityTag(event.getTarget()) : null;
        this.location = new LocationTag(event.getEntity().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

