/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.impl.entities;

import com.denizenscript.denizen.nms.v1_16.impl.entities.CraftItemProjectileImpl;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityItem;
import net.minecraft.server.v1_16_R3.EntityProjectile;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Location;

public class EntityItemProjectileImpl
extends EntityProjectile {
    public static MethodHandle setBukkitEntityMethod = ReflectionHelper.getFinalSetter(Entity.class, (String)"bukkitEntity");
    public static final DataWatcherObject<ItemStack> ITEM;

    public EntityItemProjectileImpl(World world, Location location, ItemStack item) {
        super(EntityTypes.ITEM, world);
        try {
            setBukkitEntityMethod.invoke(this, new CraftItemProjectileImpl(world.getServer(), this));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        this.setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.setItemStack(item);
    }

    protected void initDatawatcher() {
        this.getDataWatcher().register(ITEM, (Object)ItemStack.b);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.getDataWatcher().get(ITEM);
    }

    public void setItemStack(ItemStack itemstack) {
        Preconditions.checkArgument((!itemstack.isEmpty() ? 1 : 0) != 0, (Object)"Cannot drop air");
        this.getDataWatcher().set(ITEM, (Object)itemstack);
        this.getDataWatcher().markDirty(ITEM);
    }

    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        super.a(movingobjectpositionblock);
        this.die();
    }

    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (ITEM.equals(datawatcherobject)) {
            this.getItemStack().a((Entity)this);
        }
    }

    public void saveData(NBTTagCompound nbttagcompound) {
        if (!this.getItemStack().isEmpty()) {
            nbttagcompound.set("Item", (NBTBase)this.getItemStack().save(new NBTTagCompound()));
        }
        super.saveData(nbttagcompound);
    }

    public void loadData(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Item");
        this.setItemStack(ItemStack.a((NBTTagCompound)nbttagcompound1));
        if (this.getItemStack().isEmpty()) {
            this.die();
        }
        super.loadData(nbttagcompound);
    }

    public CraftItemProjectileImpl getBukkitEntity() {
        return (CraftItemProjectileImpl)super.getBukkitEntity();
    }

    static {
        DataWatcherObject watcher = null;
        try {
            watcher = (DataWatcherObject)ReflectionHelper.getFields(EntityItem.class).get((Object)"ITEM").get(null);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        ITEM = watcher;
    }
}

