/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.HashMap;
import java.util.List;

public class ChooseCommand
extends BracedCommand {
    public ChooseCommand() {
        this.setName("choose");
        this.setSyntax("choose [<option>] [<cases>]");
        this.setRequiredArguments(1, 1);
        this.isProcedural = true;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        ScriptEntry.ArgumentIterator argumentIterator = scriptEntry.iterator();
        if (argumentIterator.hasNext()) {
            Argument arg = (Argument)argumentIterator.next();
            if (!scriptEntry.hasObject("choice")) {
                scriptEntry.addObject("choice", arg.asElement());
            } else {
                arg.reportUnhandled();
            }
        }
        if (!scriptEntry.hasObject("choice")) {
            throw new InvalidArgumentsException("Must have a choice!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        String choice_low;
        Integer resultIndex;
        HashMap<String, Integer> lookupTable;
        List<BracedCommand.BracedData> bdlist = ChooseCommand.getBracedCommands(scriptEntry, false);
        if (bdlist == null || bdlist.isEmpty()) {
            Debug.echoError(scriptEntry, "Empty sub-commands (internal)!");
            return;
        }
        List<ScriptEntry> bracedCommandsList = bdlist.get((int)0).value;
        if (scriptEntry.internal.specialProcessedData instanceof HashMap) {
            lookupTable = (HashMap<String, Integer>)scriptEntry.internal.specialProcessedData;
        } else {
            lookupTable = new HashMap<String, Integer>(bracedCommandsList.size());
            for (int i = 0; i < bracedCommandsList.size(); ++i) {
                ScriptEntry se = bracedCommandsList.get(i);
                String cmdName = CoreUtilities.toLowerCase(se.getCommandName());
                if (cmdName.equals("default")) {
                    lookupTable.put("\u0000DEFAULT", i);
                    continue;
                }
                if (cmdName.equals("case")) {
                    if (se.getOriginalArguments().size() > 0) {
                        for (String arg : se.getOriginalArguments()) {
                            lookupTable.put(CoreUtilities.toLowerCase(arg), i);
                        }
                        continue;
                    }
                    Debug.echoError("Unknown choose sub-command (missing arguments) '" + se + "'!");
                    continue;
                }
                Debug.echoError("Unknown choose sub-command '" + cmdName + "'!");
            }
            scriptEntry.internal.specialProcessedData = lookupTable;
        }
        ElementTag choice = scriptEntry.getElement("choice");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), choice);
        }
        if ((resultIndex = (Integer)lookupTable.get(choice_low = choice.asLowerString())) == null && (resultIndex = (Integer)lookupTable.get("\u0000DEFAULT")) == null) {
            Debug.echoDebug((Debuggable)scriptEntry, "No result!");
            return;
        }
        ScriptEntry result = bracedCommandsList.get(resultIndex);
        List<BracedCommand.BracedData> new_commands = ChooseCommand.getBracedCommands(result);
        if (new_commands == null || new_commands.isEmpty()) {
            Debug.echoError(scriptEntry, "Empty choose command case sub-commands (internal) for case '" + result.toString() + "'");
            return;
        }
        List<ScriptEntry> new_command_list = new_commands.get((int)0).value;
        for (ScriptEntry newEntry : new_command_list) {
            newEntry.setInstant(true);
            newEntry.entryData.transferDataFrom(scriptEntry.entryData);
            newEntry.entryData.scriptEntry = newEntry;
        }
        scriptEntry.setInstant(true);
        scriptEntry.getResidingQueue().injectEntriesAtStart(new_command_list);
    }
}

