/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCookEvent;

public class BlockCooksSmeltsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockCooksSmeltsItemScriptEvent instance;
    public ItemTag source_item;
    public ItemTag result_item;
    public LocationTag location;
    public BlockCookEvent event;

    public BlockCooksSmeltsItemScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<block> cooks|smelts <item> (into <item>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.location.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.source_item.tryAdvancedMatcher(path.eventArgLowerAt(2))) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("into") && !this.result_item.tryAdvancedMatcher(path.eventArgLowerAt(4))) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "BlockCooksSmelts";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj.canBeType(ItemTag.class)) {
            this.result_item = determinationObj.asType(ItemTag.class, (TagContext)this.getTagContext(path));
            this.event.setResult(this.result_item.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "source_item": {
                return this.source_item;
            }
            case "result_item": {
                return this.result_item;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockCooks(BlockCookEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.source_item = new ItemTag(event.getSource());
        this.result_item = new ItemTag(event.getResult());
        this.event = event;
        this.fire((Event)event);
    }
}

