/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;

public class PlayerPreLoginScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPreLoginScriptEvent instance;
    public AsyncPlayerPreLoginEvent event;
    public PlayerTag player;
    public List<QueueTag> waitForQueues = new ArrayList<QueueTag>();

    public PlayerPreLoginScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player prelogin");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determinationObj instanceof ElementTag && CoreUtilities.toLowerCase(determination).startsWith("kicked")) {
            String message = determination.length() > 7 ? determination.substring(7) : determination;
            this.event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, message);
            return true;
        }
        if (QueueTag.matches(determination)) {
            QueueTag newQueue = QueueTag.valueOf(determination, this.getTagContext(path));
            if (newQueue != null && newQueue.getQueue() != null) {
                this.waitForQueues.add(newQueue);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "hostname": {
                return new ElementTag(this.event.getAddress().toString());
            }
            case "name": {
                return new ElementTag(this.event.getName());
            }
            case "uuid": {
                return new ElementTag(this.event.getUniqueId().toString());
            }
        }
        return super.getContext(name);
    }

    public boolean needsToWait() {
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Prelogin: queues that might need waiting: " + this.waitForQueues.size());
        }
        for (QueueTag queue : this.waitForQueues) {
            if (queue.getQueue().isStopped) continue;
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Prelogin: need to wait for " + queue.getQueue().id);
            }
            return true;
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.log("Prelogin: no need to wait");
        }
        return false;
    }

    @EventHandler
    public void onPlayerLogin(AsyncPlayerPreLoginEvent event) {
        if (!Bukkit.isPrimaryThread()) {
            PlayerPreLoginScriptEvent altEvent = (PlayerPreLoginScriptEvent)this.clone();
            Future future = Bukkit.getScheduler().callSyncMethod((Plugin)Denizen.getInstance(), () -> {
                altEvent.onPlayerLogin(event);
                return null;
            });
            try {
                future.get(30L, TimeUnit.SECONDS);
                while (altEvent.needsToWait()) {
                    Thread.sleep(50L);
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            return;
        }
        this.waitForQueues = new ArrayList<QueueTag>();
        OfflinePlayer bukkitPlayer = Bukkit.getOfflinePlayer((UUID)event.getUniqueId());
        this.player = bukkitPlayer != null && bukkitPlayer.getName() != null ? new PlayerTag(bukkitPlayer) : null;
        this.event = event;
        this.fire((Event)event);
    }
}

