/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.ThunderChangeEvent;

public class ThunderChangesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ThunderChangesScriptEvent instance;
    public ThunderChangeEvent event;

    public ThunderChangesScriptEvent() {
        instance = this;
        this.registerCouldMatcher("thunder changes|begins|clears");
        this.registerSwitches("in");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String changeType = path.eventArgLowerAt(1);
        if (changeType.equals("clears") ? this.event.toThunderState() : (changeType.equals("begins") ? !this.event.toThunderState() : !changeType.equals("changes"))) {
            return false;
        }
        if (!path.tryObjectSwitch("in", new WorldTag(this.event.getWorld()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "world": {
                return new WorldTag(this.event.getWorld());
            }
            case "thunder": {
                return new ElementTag(this.event.toThunderState());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onThunderChanges(ThunderChangeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

