/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WeatherChangesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static WeatherChangesScriptEvent instance;
    public WorldTag world;
    public ElementTag weather;
    public WeatherChangeEvent event;

    public WeatherChangesScriptEvent() {
        instance = this;
        this.registerCouldMatcher("weather changes|rains|clears (in <world>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (!cmd.equals("changes") && !cmd.equals(this.weather.asString())) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("in") && !this.world.tryAdvancedMatcher(path.eventArgLowerAt(3))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("weather")) {
            return this.weather;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onWeatherChanges(WeatherChangeEvent event) {
        this.world = new WorldTag(event.getWorld());
        this.weather = new ElementTag(event.toWeatherState() ? "rains" : "clears");
        this.event = event;
        this.fire((Event)event);
    }
}

