/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import java.util.Iterator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;

public class ChunkLoadEntitiesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ChunkLoadEntitiesScriptEvent instance;
    public ChunkTag chunk;
    public EntitiesLoadEvent event;

    public ChunkLoadEntitiesScriptEvent() {
        instance = this;
        this.registerCouldMatcher("chunk loads entities");
        this.registerSwitches("entity_type", "include_empty");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.checkSwitch("include_empty", "false") && this.event.getEntities().isEmpty()) {
            return false;
        }
        if (!this.runInCheck(path, this.chunk.getCenter())) {
            return false;
        }
        String typeMatch = path.switches.get("entity_type");
        if (typeMatch != null) {
            Entity e;
            boolean any = false;
            Iterator iterator = this.event.getEntities().iterator();
            while (iterator.hasNext() && !(any = new EntityTag(e = (Entity)iterator.next()).tryAdvancedMatcher(typeMatch))) {
            }
            if (!any) {
                return false;
            }
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "chunk": {
                return this.chunk;
            }
            case "entities": {
                ListTag entList = new ListTag();
                for (Entity e : this.event.getEntities()) {
                    entList.addObject(new EntityTag(e));
                }
                return entList;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onChunkLoad(EntitiesLoadEvent event) {
        this.chunk = new ChunkTag(event.getChunk());
        this.event = event;
        this.fire((Event)event);
    }
}

