/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;

public class EntityCombustsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityCombustsScriptEvent instance;
    public EntityTag entity;
    public EntityCombustEvent event;

    public EntityCombustsScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> combusts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.event.setDuration(((ElementTag)determinationObj).asInt());
            return true;
        }
        if (DurationTag.matches(determinationObj.toString())) {
            this.event.setDuration(DurationTag.valueOf(determinationObj.toString(), this.getTagContext(path)).getTicksAsInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "duration": {
                return new DurationTag(this.event.getDuration());
            }
            case "source": {
                Block combuster;
                if (this.event instanceof EntityCombustByEntityEvent) {
                    return new EntityTag(((EntityCombustByEntityEvent)this.event).getCombuster()).getDenizenObject();
                }
                if (!(this.event instanceof EntityCombustByBlockEvent) || (combuster = ((EntityCombustByBlockEvent)this.event).getCombuster()) == null) break;
                return new LocationTag(combuster.getLocation());
            }
            case "source_type": {
                if (this.event instanceof EntityCombustByEntityEvent) {
                    return new ElementTag("ENTITY");
                }
                if (this.event instanceof EntityCombustByBlockEvent) {
                    return new ElementTag("LOCATION");
                }
                return new ElementTag("NONE");
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityCombusts(EntityCombustEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }
}

