/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;

public class EntityDropsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityDropsItemScriptEvent instance;
    public ItemTag item;
    public LocationTag location;
    public EntityTag itemEntity;
    public EntityTag dropper;

    public EntityDropsItemScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> drops <item>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.dropper.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        String iCheck = path.eventArgLowerAt(2);
        if (!this.item.tryAdvancedMatcher(iCheck)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.dropper);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return this.item;
            }
            case "entity": {
                return this.itemEntity;
            }
            case "dropped_by": {
                return this.dropper.getDenizenObject();
            }
            case "location": {
                return this.location;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerDropsItem(PlayerDropItemEvent event) {
        this.dropper = new EntityTag((Entity)event.getPlayer());
        this.location = this.dropper.getLocation();
        this.itemEntity = new EntityTag((Entity)event.getItemDrop());
        EntityTag.rememberEntity(this.itemEntity.getBukkitEntity());
        this.item = new ItemTag(((Item)this.itemEntity.getBukkitEntity()).getItemStack());
        this.fire((Event)event);
    }

    @EventHandler
    public void onEntityDropsItem(EntityDropItemEvent event) {
        this.dropper = new EntityTag(event.getEntity());
        this.location = this.dropper.getLocation();
        this.itemEntity = new EntityTag((Entity)event.getItemDrop());
        EntityTag.rememberEntity(this.itemEntity.getBukkitEntity());
        this.item = new ItemTag(((Item)this.itemEntity.getBukkitEntity()).getItemStack());
        this.fire((Event)event);
    }
}

