/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityInteractEvent;

public class EntityInteractScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityInteractScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    private MaterialTag material;
    public EntityInteractEvent event;

    public EntityInteractScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> interacts with <block>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.material.tryAdvancedMatcher(path.eventArgLowerAt(3))) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityInteract(EntityInteractEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

