/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;

public class EntityPicksUpItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityPicksUpItemScriptEvent instance;
    public ItemTag item;
    public EntityTag entity;
    public LocationTag location;
    public EntityPickupItemEvent event;
    private static final Set<UUID> editedItems;

    public EntityPicksUpItemScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<entity> picks up <item>");
        this.registerCouldMatcher("<entity> takes <item>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.entity.tryAdvancedMatcher(path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.item.tryAdvancedMatcher(path.eventArgLowerAt(path.eventArgLowerAt(1).equals("picks") ? 3 : 2))) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("item:")) {
            this.item = ItemTag.valueOf(determination.substring("item:".length()), path.container);
            editedItems.add(this.event.getItem().getUniqueId());
            this.event.getItem().setItemStack(this.item.getItemStack());
            this.event.setCancelled(true);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return this.item;
            }
            case "entity": {
                return new EntityTag((Entity)this.event.getItem());
            }
            case "pickup_entity": {
                return this.entity;
            }
            case "location": {
                return this.location;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityPicksUpItem(EntityPickupItemEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        Item itemEntity = event.getItem();
        UUID itemUUID = itemEntity.getUniqueId();
        if (editedItems.contains(itemUUID)) {
            editedItems.remove(itemUUID);
            return;
        }
        this.location = new LocationTag(itemEntity.getLocation());
        this.item = new ItemTag(itemEntity.getItemStack());
        this.event = event;
        this.fire((Event)event);
    }

    static {
        editedItems = new HashSet<UUID>();
    }
}

