/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.item;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;

public class ItemMoveScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemMoveScriptEvent instance;
    public InventoryTag origin;
    public InventoryTag destination;
    public ItemTag item;
    public InventoryMoveItemEvent event;

    public ItemMoveScriptEvent() {
        instance = this;
        this.registerCouldMatcher("<item> moves from <inventory> (to <inventory>)");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.item.tryAdvancedMatcher(path.eventArgAt(0))) {
            return false;
        }
        if (!this.origin.tryAdvancedMatcher(path.eventArgAt(3))) {
            return false;
        }
        if (path.eventArgLowerAt(4).equals("to") && !this.destination.tryAdvancedMatcher(path.eventArgAt(5))) {
            return false;
        }
        if (!this.runInCheck(path, this.origin.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj.canBeType(ItemTag.class)) {
            this.item = determinationObj.asType(ItemTag.class, (TagContext)this.getTagContext(path));
            this.event.setItem(this.item.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "origin": {
                return this.origin;
            }
            case "destination": {
                return this.destination;
            }
            case "initiator": {
                return InventoryTag.mirrorBukkitInventory(this.event.getInitiator());
            }
            case "item": {
                return this.item;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        this.event = event;
        this.origin = InventoryTag.mirrorBukkitInventory(event.getSource());
        this.destination = InventoryTag.mirrorBukkitInventory(event.getDestination());
        this.item = new ItemTag(event.getItem());
        this.fire((Event)event);
    }
}

