/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerClicksInInventoryScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerClicksInInventoryScriptEvent instance;
    public InventoryTag inventory;
    public ItemTag item;
    public ItemTag cursor;
    public InventoryClickEvent event;
    private static final HashSet<String> matchHelpList;

    public PlayerClicksInInventoryScriptEvent() {
        instance = this;
        this.registerCouldMatcher("player (<'click_type'>) clicks (<item>) in <inventory>");
        this.registerSwitches("with", "in_area", "action", "slot");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        boolean clickFirst = path.eventArgLowerAt(1).equals("clicks");
        if (!clickFirst && !path.eventArgLowerAt(2).equals("clicks")) {
            return false;
        }
        String clickedOn = path.eventArgLowerAt(clickFirst ? 2 : 3);
        if (matchHelpList.contains(clickedOn)) {
            return false;
        }
        int inIndex = -1;
        for (int i = 0; i < path.eventArgsLower.length; ++i) {
            if (!path.eventArgLowerAt(i).equals("in")) continue;
            inIndex = i;
        }
        return inIndex != -1;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        boolean hasClickType = path.eventArgLowerAt(2).equals("clicks");
        if (hasClickType && !PlayerClicksInInventoryScriptEvent.runGenericCheck(path.eventArgLowerAt(1), this.event.getClick().name())) {
            return false;
        }
        String clickedItemText = path.eventArgLowerAt(hasClickType ? 3 : 2);
        if (!clickedItemText.equals("in") && !this.item.tryAdvancedMatcher(clickedItemText)) {
            return false;
        }
        int inIndex = -1;
        for (int i = 0; i < path.eventArgsLower.length; ++i) {
            if (!path.eventArgLowerAt(i).equals("in")) continue;
            inIndex = i;
        }
        if (!this.inventory.tryAdvancedMatcher(path.eventArgLowerAt(inIndex + 1))) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.runWithCheck(path, this.cursor)) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.nonSwitchWithCheck(path, this.cursor)) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getWhoClicked().getLocation(), "in_area")) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.runGenericSwitchCheck(path, "action", this.event.getAction().name())) {
            return false;
        }
        if (!PlayerClicksInInventoryScriptEvent.runGenericSwitchCheck(path, "slot", String.valueOf(this.event.getSlot() + 1)) && !PlayerClicksInInventoryScriptEvent.runGenericSwitchCheck(path, "slot", this.event.getSlotType().name())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj.canBeType(ItemTag.class)) {
            this.event.setCurrentItem(determinationObj.asType(ItemTag.class, (TagContext)this.getTagContext(path)).getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getWhoClicked());
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("inventory")) {
            return this.inventory;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("cursor_item")) {
            return this.cursor;
        }
        if (name.equals("click")) {
            return new ElementTag(this.event.getClick().name());
        }
        if (name.equals("action")) {
            return new ElementTag(this.event.getAction().name());
        }
        if (name.equals("slot_type")) {
            return new ElementTag(this.event.getSlotType().name());
        }
        if (name.equals("is_shift_click")) {
            return new ElementTag(this.event.isShiftClick());
        }
        if (name.equals("clicked_inventory") && this.event.getClickedInventory() != null) {
            return InventoryTag.mirrorBukkitInventory(this.event.getClickedInventory());
        }
        if (name.equals("slot")) {
            return new ElementTag(this.event.getSlot() + 1);
        }
        if (name.equals("raw_slot")) {
            return new ElementTag(this.event.getRawSlot() + 1);
        }
        if (name.equals("hotbar_button")) {
            return new ElementTag(this.event.getHotbarButton() + 1);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        this.inventory = InventoryTag.mirrorBukkitInventory(event.getInventory());
        this.item = event.getCurrentItem() == null ? new ItemTag(Material.AIR) : new ItemTag(event.getCurrentItem().clone());
        this.cursor = new ItemTag(event.getCursor() == null ? new ItemStack(Material.AIR) : event.getCursor().clone());
        this.event = event;
        this.fire((Event)event);
    }

    static {
        matchHelpList = new HashSet<String>(Arrays.asList("at", "entity", "npc", "player", "vehicle", "projectile", "hanging", "fake"));
    }
}

