/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.GenericGameEvent;

public class GenericGameEventScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static GenericGameEventScriptEvent instance;
    public LocationTag location;
    public GenericGameEvent event;

    public GenericGameEventScriptEvent() {
        instance = this;
        this.registerCouldMatcher("generic game event");
        this.registerSwitches("type");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String typeSwitch = path.switches.get("type");
        if (typeSwitch != null && !GenericGameEventScriptEvent.runGenericCheck(typeSwitch, this.event.getEvent().getKey().toString()) && !GenericGameEventScriptEvent.runGenericCheck(typeSwitch, this.event.getEvent().getKey().getKey())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getEntity());
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "entity": {
                if (this.event.getEntity() == null) break;
                return new EntityTag(this.event.getEntity()).getDenizenObject();
            }
            case "game_event": {
                return new ElementTag(this.event.getEvent().getKey().toString());
            }
            case "radius": {
                return new ElementTag(this.event.getRadius());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onGenericGameEvent(GenericGameEvent event) {
        this.location = new LocationTag(event.getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

